/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ObjectCollection;
import com.carrotsearch.hppcrt.ObjectLookupContainer;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    protected ObjectLookupContainer<? super KType> testContainer;
    protected ObjectPredicate<? super KType> testPredicate;
    protected ObjectPredicate<KType> containsTestPredicate = new ObjectPredicate<KType>(){

        @Override
        public final boolean apply(KType k) {
            return AbstractObjectCollection.this.testContainer.contains(k);
        }
    };
    protected ObjectPredicate<KType> containsNegateTestPredicate = new ObjectPredicate<KType>(){

        @Override
        public final boolean apply(KType k) {
            return !AbstractObjectCollection.this.testContainer.contains(k);
        }
    };
    protected ObjectPredicate<KType> negatePredicate = new ObjectPredicate<KType>(){

        @Override
        public final boolean apply(KType k) {
            return !AbstractObjectCollection.this.testPredicate.apply(k);
        }
    };

    @Override
    public int removeAll(ObjectLookupContainer<? super KType> c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    @Override
    public int retainAll(ObjectLookupContainer<? super KType> c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    @Override
    public int retainAll(ObjectPredicate<? super KType> predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    @Override
    public <T> T[] toArray(Class<T> componentClass) {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(componentClass, size);
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    @Override
    public KType[] toArray(KType[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (ObjectCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    @Override
    public Object[] toArray() {
        try {
            return this.toArray(new Object[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

