/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.DoubleIndexedContainer;
import java.util.Arrays;

public final class DoubleArrays {
    public static final double[] EMPTY = new double[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final double[] BLANKING_OBJECT_ARRAY = new double[1024];

    private DoubleArrays() {
    }

    public static void rotate(double[] table, int from, int mid, int to) {
        DoubleArrays.reverse(table, from, mid);
        DoubleArrays.reverse(table, mid, to);
        DoubleArrays.reverse(table, from, to);
    }

    public static void rotate(DoubleIndexedContainer table, int from, int mid, int to) {
        DoubleArrays.reverse(table, from, mid);
        DoubleArrays.reverse(table, mid, to);
        DoubleArrays.reverse(table, from, to);
    }

    public static void reverse(double[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            double tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static void reverse(DoubleIndexedContainer table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            double tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static void blankArray(double[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, 0.0);
        }
    }
}

