/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectPriorityQueue;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHeapPriorityQueue<KType>
extends AbstractObjectCollection<KType>
implements ObjectPriorityQueue<KType>,
Cloneable {
    public Object[] buffer;
    protected int elementsCount;
    protected Comparator<? super KType> comparator;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ObjectCursor<KType>, ValueIterator> valueIteratorPool;
    protected KType currentOccurenceToBeRemoved;
    protected ObjectPredicate<? super KType> removeAllOccurencesPredicate = new ObjectPredicate<KType>(){

        @Override
        public final boolean apply(KType value) {
            return value == null ? ObjectHeapPriorityQueue.this.currentOccurenceToBeRemoved == null : value.equals(ObjectHeapPriorityQueue.this.currentOccurenceToBeRemoved);
        }
    };
    protected KType defaultValue;

    public ObjectHeapPriorityQueue(Comparator<? super KType> comp, int initialCapacity, ArraySizingStrategy resizer) {
        this.comparator = comp;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = 0;
                obj.size = ObjectHeapPriorityQueue.this.size();
                ValueIterator.access$102(obj, ObjectHeapPriorityQueue.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
                obj.cursor.value = null;
            }
        });
    }

    public ObjectHeapPriorityQueue(Comparator<? super KType> comp) {
        this(comp, 8);
    }

    public ObjectHeapPriorityQueue() {
        this(null, 8);
    }

    public ObjectHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectHeapPriorityQueue(Comparator<? super KType> comp, int initialCapacity) {
        this(comp, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectHeapPriorityQueue(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    public static <KType> ObjectHeapPriorityQueue<KType> from(ObjectContainer<KType> container) {
        return new ObjectHeapPriorityQueue<KType>(container);
    }

    public static <KType> ObjectHeapPriorityQueue<KType> from(KType ... elements) {
        ObjectHeapPriorityQueue<KType> heap = new ObjectHeapPriorityQueue<KType>(elements.length);
        for (KType elem : elements) {
            heap.add(elem);
        }
        return heap;
    }

    @Override
    public int removeAll(KType e1) {
        this.currentOccurenceToBeRemoved = e1;
        return this.removeAll(this.removeAllOccurencesPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int deleted = 0;
        Object[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    buffer[pos] = buffer[elementsCount];
                    buffer[elementsCount] = null;
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    @Override
    public void clear() {
        ObjectArrays.blankArray(this.buffer, 1, this.elementsCount + 1);
        this.elementsCount = 0;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public boolean contains(KType element) {
        int size = this.elementsCount;
        Object[] buff = this.buffer;
        for (int i = 1; i <= size; ++i) {
            if (!(element == null ? buff[i] == null : element.equals(buff[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        Object[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size; ++i) {
            procedure.apply((Object)buff[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        Object[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size && predicate.apply((Object)buff[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public void add(KType element) {
        this.ensureBufferSpace(1);
        ++this.elementsCount;
        this.buffer[this.elementsCount] = element;
        this.swim(this.elementsCount);
    }

    @Override
    public KType top() {
        Object elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    @Override
    public KType popTop() {
        Object elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            if (this.elementsCount == 1) {
                this.buffer[1] = null;
                this.elementsCount = 0;
            } else {
                this.buffer[1] = this.buffer[this.elementsCount];
                this.buffer[this.elementsCount] = null;
                --this.elementsCount;
                this.sink(1);
            }
        }
        return elem;
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        Object[] buff = this.buffer;
        int count = this.elementsCount;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.ensureBufferSpace(1);
            buff[++count] = objectCursor.value;
            ++size;
        }
        this.elementsCount = count;
        this.updatePriorities();
        return size;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        Object[] buff = this.buffer;
        for (int i = 1; i <= max; ++i) {
            h = 31 * h + BitMixer.mix(buff[i]);
        }
        return h;
    }

    @Override
    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    public ObjectHeapPriorityQueue<KType> clone() {
        ObjectHeapPriorityQueue<? super KType> cloned = new ObjectHeapPriorityQueue<KType>(this.comparator, 8, this.resizer);
        cloned.buffer = (Object[])this.buffer.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectHeapPriorityQueue other = (ObjectHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            ValueIterator it = this.iterator();
            ValueIterator itOther = other.iterator();
            while (it.hasNext()) {
                Object myVal = ((ObjectCursor)it.next()).value;
                Object otherVal = ((ObjectCursor)itOther.next()).value;
                if (myVal != null ? myVal.equals(otherVal) : otherVal == null) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                Object[] newBuffer = new Object[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public KType[] toArray(KType[] target) {
        System.arraycopy(this.buffer, 1, target, 0, this.elementsCount);
        return target;
    }

    public Comparator<? super KType> comparator() {
        return this.comparator;
    }

    @Override
    public KType getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(KType defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        Object[] buffer = this.buffer;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && ((Comparable)buffer[child]).compareTo(buffer[child + 1]) > 0) {
                ++child;
            }
            if (((Comparable)buffer[k]).compareTo(buffer[child]) <= 0) break;
            Object tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        Object[] buffer = this.buffer;
        Comparator<KType> comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            Object tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void swimComparable(int k) {
        Object[] buffer = this.buffer;
        while (k > 1 && ((Comparable)buffer[k >> 1]).compareTo(buffer[k]) > 0) {
            int parent = k >> 1;
            Object tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        Object[] buffer = this.buffer;
        Comparator<KType> comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            Object tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        private KType[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = 0;
            this.size = ObjectHeapPriorityQueue.this.size();
            this.buffer = ObjectHeapPriorityQueue.this.buffer;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ Object[] access$102(ValueIterator x0, Object[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

