/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortPriorityQueue;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;
import com.carrotsearch.hppcrt.strategies.ShortComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortHeapPriorityQueue
extends AbstractShortCollection
implements ShortPriorityQueue,
Cloneable {
    public short[] buffer;
    protected int elementsCount;
    protected ShortComparator comparator;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ShortCursor, ValueIterator> valueIteratorPool;
    protected short currentOccurenceToBeRemoved;
    protected ShortPredicate removeAllOccurencesPredicate = new ShortPredicate(){

        public final boolean apply(short value) {
            return value == ShortHeapPriorityQueue.this.currentOccurenceToBeRemoved;
        }
    };
    protected short defaultValue;

    public ShortHeapPriorityQueue(ShortComparator comp, int initialCapacity, ArraySizingStrategy resizer) {
        this.comparator = comp;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = 0;
                obj.size = ShortHeapPriorityQueue.this.size();
                ValueIterator.access$102(obj, ShortHeapPriorityQueue.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public ShortHeapPriorityQueue(ShortComparator comp) {
        this(comp, 8);
    }

    public ShortHeapPriorityQueue() {
        this(null, 8);
    }

    public ShortHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ShortHeapPriorityQueue(ShortComparator comp, int initialCapacity) {
        this(comp, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ShortHeapPriorityQueue(ShortContainer container) {
        this(container.size());
        this.addAll(container);
    }

    public static ShortHeapPriorityQueue from(ShortContainer container) {
        return new ShortHeapPriorityQueue(container);
    }

    public static ShortHeapPriorityQueue from(short ... elements) {
        ShortHeapPriorityQueue heap = new ShortHeapPriorityQueue(elements.length);
        for (short elem : elements) {
            heap.add(elem);
        }
        return heap;
    }

    @Override
    public int removeAll(short e1) {
        this.currentOccurenceToBeRemoved = e1;
        return this.removeAll(this.removeAllOccurencesPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ShortPredicate predicate) {
        int deleted = 0;
        short[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    buffer[pos] = buffer[elementsCount];
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public boolean contains(short element) {
        int size = this.elementsCount;
        short[] buff = this.buffer;
        for (int i = 1; i <= size; ++i) {
            if (element != buff[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        short[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size; ++i) {
            procedure.apply(buff[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        short[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size && predicate.apply(buff[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public void add(short element) {
        this.ensureBufferSpace(1);
        ++this.elementsCount;
        this.buffer[this.elementsCount] = element;
        this.swim(this.elementsCount);
    }

    @Override
    public short top() {
        short elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    @Override
    public short popTop() {
        short elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            if (this.elementsCount == 1) {
                this.elementsCount = 0;
            } else {
                this.buffer[1] = this.buffer[this.elementsCount];
                --this.elementsCount;
                this.sink(1);
            }
        }
        return elem;
    }

    public int addAll(ShortContainer container) {
        return this.addAll((Iterable<? extends ShortCursor>)container);
    }

    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int size = 0;
        short[] buff = this.buffer;
        int count = this.elementsCount;
        for (ShortCursor shortCursor : iterable) {
            this.ensureBufferSpace(1);
            buff[++count] = shortCursor.value;
            ++size;
        }
        this.elementsCount = count;
        this.updatePriorities();
        return size;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        short[] buff = this.buffer;
        for (int i = 1; i <= max; ++i) {
            h = 31 * h + BitMixer.mix(buff[i]);
        }
        return h;
    }

    @Override
    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    public ShortHeapPriorityQueue clone() {
        ShortHeapPriorityQueue cloned = new ShortHeapPriorityQueue(this.comparator, 8, this.resizer);
        cloned.buffer = (short[])this.buffer.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortHeapPriorityQueue other = (ShortHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            ValueIterator it = this.iterator();
            ValueIterator itOther = other.iterator();
            while (it.hasNext()) {
                short myVal = ((ShortCursor)it.next()).value;
                short otherVal = ((ShortCursor)itOther.next()).value;
                if (myVal == otherVal) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                short[] newBuffer = new short[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public short[] toArray(short[] target) {
        System.arraycopy(this.buffer, 1, target, 0, this.elementsCount);
        return target;
    }

    public ShortComparator comparator() {
        return this.comparator;
    }

    @Override
    public short getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(short defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        short[] buffer = this.buffer;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && buffer[child] > buffer[child + 1]) {
                ++child;
            }
            if (buffer[k] <= buffer[child]) break;
            short tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        short[] buffer = this.buffer;
        ShortComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            short tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void swimComparable(int k) {
        short[] buffer = this.buffer;
        while (k > 1 && buffer[k >> 1] > buffer[k]) {
            int parent = k >> 1;
            short tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        short[] buffer = this.buffer;
        ShortComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            short tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();
        private short[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = 0;
            this.size = ShortHeapPriorityQueue.this.size();
            this.buffer = ShortHeapPriorityQueue.this.buffer;
        }

        @Override
        protected ShortCursor fetch() {
            if (this.cursor.index == this.size) {
                return (ShortCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ short[] access$102(ValueIterator x0, short[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

