/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectDeque;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectIndexedContainer;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.ObjectLinkedList;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import com.carrotsearch.hppcrt.sorting.ObjectSort;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayDeque<KType>
extends AbstractObjectCollection<KType>
implements ObjectDeque<KType>,
ObjectIndexedContainer<KType>,
Cloneable {
    public Object[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ObjectCursor<KType>, DescendingValueIterator> descendingValueIteratorPool;
    protected final IteratorPool<ObjectCursor<KType>, ValueIterator> valueIteratorPool;

    public ObjectArrayDeque() {
        this(8);
    }

    public ObjectArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = ObjectArrayDeque.this.head >= 1 ? ObjectArrayDeque.this.head - 1 : ObjectArrayDeque.this.buffer.length - 1;
                obj.remaining = ObjectArrayDeque.this.size();
            }

            @Override
            public void reset(ValueIterator obj) {
                obj.cursor.value = null;
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = ObjectArrayDeque.this.tail;
                obj.remaining = ObjectArrayDeque.this.size();
            }

            @Override
            public void reset(DescendingValueIterator obj) {
                obj.cursor.value = null;
            }
        });
    }

    public ObjectArrayDeque(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(KType e1) {
        int h;
        int n = h = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = this.head >= 1 ? this.head - 1 : this.buffer.length - 1;
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    @Override
    public void addFirst(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public int addFirst(ObjectContainer<? extends KType> container) {
        return this.addFirst((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addFirst(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addFirst((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(KType e1) {
        int t;
        int n = t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = this.tail + 1 == this.buffer.length ? 0 : this.tail + 1;
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    @Override
    public void addLast(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public int addLast(ObjectContainer<? extends KType> container) {
        return this.addLast((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addLast((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public KType removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        Object result = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = this.head + 1 == this.buffer.length ? 0 : this.head + 1;
        return (KType)result;
    }

    @Override
    public KType removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1;
        Object result = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        return (KType)result;
    }

    @Override
    public KType getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[this.head];
    }

    @Override
    public KType getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[this.tail >= 1 ? this.tail - 1 : this.buffer.length - 1];
    }

    @Override
    public int removeFirst(KType e1) {
        int pos = -1;
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int bufferIndexOf(KType e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        Object[] buffer = this.buffer;
        int i = this.head;
        while (i != last) {
            if (e1 == null ? buffer[i] == null : e1.equals(buffer[i])) {
                return i;
            }
            i = i + 1 == bufLen ? 0 : i + 1;
        }
        return -1;
    }

    @Override
    public int removeLast(KType e1) {
        int pos = -1;
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            pos = this.bufferIndexToPosition(index);
            this.removeBufferIndicesRange(index, index + 1 == this.buffer.length ? 0 : index + 1);
        }
        return pos;
    }

    public int lastBufferIndexOf(KType e1) {
        int i;
        int bufLen = this.buffer.length;
        int last = this.head >= 1 ? this.head - 1 : bufLen - 1;
        Object[] buffer = this.buffer;
        int n = i = this.tail >= 1 ? this.tail - 1 : bufLen - 1;
        while (i != last) {
            if (e1 == null ? buffer[i] == null : e1.equals(buffer[i])) {
                return i;
            }
            i = i >= 1 ? i - 1 : bufLen - 1;
        }
        return -1;
    }

    @Override
    public int indexOf(KType e1) {
        return this.bufferIndexToPosition(this.bufferIndexOf(e1));
    }

    @Override
    public int lastIndexOf(KType e1) {
        return this.bufferIndexToPosition(this.lastBufferIndexOf(e1));
    }

    @Override
    public int removeAll(KType e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        Object[] buffer = this.buffer;
        int from = to = this.head;
        while (from != last) {
            if (e1 == null ? buffer[from] == null : e1.equals(buffer[from])) {
                buffer[from] = null;
                ++removed;
            } else {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            ObjectArrays.blankArray(this.buffer, this.head, this.tail);
        } else {
            ObjectArrays.blankArray(this.buffer, 0, this.tail);
            ObjectArrays.blankArray(this.buffer, this.head, this.buffer.length);
        }
        this.tail = 0;
        this.head = 0;
    }

    private void compactBeforeSorting() {
        if (this.head > this.tail) {
            int size = this.size();
            int hole = this.head - this.tail;
            System.arraycopy(this.buffer, this.head, this.buffer, this.tail, this.buffer.length - this.head);
            this.head = 0;
            this.tail = size;
            ObjectArrays.blankArray(this.buffer, this.tail, this.tail + hole);
        }
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = new Object[8];
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int elementsCount;
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int n = elementsCount = this.buffer == null ? 0 : this.size();
        if (elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                Object[] newBuffer = new Object[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public KType[] toArray(KType[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ObjectArrayDeque<KType> clone() {
        ObjectArrayDeque<KType> cloned = new ObjectArrayDeque<KType>(8, this.resizer);
        cloned.buffer = (Object[])this.buffer.clone();
        cloned.head = this.head;
        cloned.tail = this.tail;
        return cloned;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        this.internalForEach(procedure, this.head, this.tail);
        return procedure;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return procedure;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(procedure, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return procedure;
    }

    private void internalForEach(ObjectProcedure<? super KType> procedure, int fromIndexBuffer, int toIndexBuffer) {
        Object[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer) {
            procedure.apply(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        this.internalForEach(predicate, this.head, this.tail);
        return predicate;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return predicate;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int endBufferPosInclusive = this.indexToBufferPosition(toIndex - 1);
        this.internalForEach(predicate, bufferPositionStart, endBufferPosInclusive + 1 == this.buffer.length ? 0 : endBufferPosInclusive + 1);
        return predicate;
    }

    private void internalForEach(ObjectPredicate<? super KType> predicate, int fromIndexBuffer, int toIndexBuffer) {
        Object[] buffer = this.buffer;
        int i = fromIndexBuffer;
        while (i != toIndexBuffer && predicate.apply(buffer[i])) {
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = i >= 1 ? i - 1 : buffer.length - 1;
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i = toIndex;
        do {
            int n = i = i >= 1 ? i - 1 : buffer.length - 1;
        } while (predicate.apply(buffer[i]) && i != fromIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        Object[] buffer = this.buffer;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = null;
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                        buffer[from] = null;
                    }
                    to = to + 1 == bufLen ? 0 : to + 1;
                }
                from = from + 1 == bufLen ? 0 : from + 1;
            }
        }
        catch (Throwable throwable) {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                to = to + 1 == bufLen ? 0 : to + 1;
                from = from + 1 == bufLen ? 0 : from + 1;
            }
            this.tail = to;
            throw throwable;
        }
        while (from != last) {
            if (to != from) {
                buffer[to] = buffer[from];
                buffer[from] = null;
            }
            to = to + 1 == bufLen ? 0 : to + 1;
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
        return removed;
    }

    @Override
    public boolean contains(KType e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == null ? buffer[i] == null : e.equals(buffer[i])) {
                return true;
            }
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(buffer[i]);
            i = i + 1 == buffer.length ? 0 : i + 1;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectLinkedList) {
                ObjectLinkedList other = (ObjectLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                ObjectLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    Object myVal = ((ObjectCursor)it.next()).value;
                    Object otherVal = ((ObjectCursor)itOther.next()).value;
                    if (myVal != null ? myVal.equals(otherVal) : otherVal == null) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof ObjectIndexedContainer) {
                ObjectIndexedContainer other = (ObjectIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean allIndexesEqual(ObjectIndexedContainer<KType> b1, ObjectIndexedContainer<KType> b2, int length) {
        for (int i = 0; i < length; ++i) {
            KType o1 = b1.get(i);
            KType o2 = b2.get(i);
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public static <KType> ObjectArrayDeque<KType> newInstance() {
        return new ObjectArrayDeque<KType>();
    }

    public static <KType> ObjectArrayDeque<KType> newInstance(int initialCapacity) {
        return new ObjectArrayDeque<KType>(initialCapacity);
    }

    public static <KType> ObjectArrayDeque<KType> from(KType ... elements) {
        ObjectArrayDeque<KType> coll = new ObjectArrayDeque<KType>(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static <KType> ObjectArrayDeque<KType> from(ObjectContainer<KType> container) {
        return new ObjectArrayDeque<KType>(container);
    }

    public void sort(int beginIndex, int endIndex) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            ObjectSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1);
        } else {
            ObjectSort.quicksort(this, beginIndex, endIndex);
        }
    }

    public void sort(int beginIndex, int endIndex, Comparator<? super KType> comp) {
        this.checkRangeBounds(beginIndex, endIndex);
        if (beginIndex == endIndex) {
            return;
        }
        int bufferPosStart = this.indexToBufferPosition(beginIndex);
        int bufferPosEndInclusive = this.indexToBufferPosition(endIndex - 1);
        if (bufferPosEndInclusive > bufferPosStart) {
            ObjectSort.quicksort(this.buffer, bufferPosStart, bufferPosEndInclusive + 1, comp);
        } else {
            ObjectSort.quicksort(this, beginIndex, endIndex, comp);
        }
    }

    public void sort() {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            ObjectSort.quicksort(this.buffer, this.head, this.tail);
        }
    }

    public void sort(Comparator<? super KType> comp) {
        if (this.size() > 1) {
            this.compactBeforeSorting();
            ObjectSort.quicksort(this.buffer, this.head, this.tail, comp);
        }
    }

    @Override
    public void add(KType e1) {
        this.addLast(e1);
    }

    @Override
    public void insert(int index, KType e1) {
        throw new UnsupportedOperationException("insert(final int index, final KType e1) operation is not supported on KTypeArrayDeque");
    }

    @Override
    public KType set(int index, KType e1) {
        int indexInBuffer = this.indexToBufferPosition(index);
        Object previous = this.buffer[indexInBuffer];
        this.buffer[indexInBuffer] = e1;
        return (KType)previous;
    }

    @Override
    public KType get(int index) {
        return (KType)this.buffer[this.indexToBufferPosition(index)];
    }

    @Override
    public KType remove(int index) {
        int indexInBuffer = this.indexToBufferPosition(index);
        Object previous = this.buffer[indexInBuffer];
        this.removeBufferIndicesRange(indexInBuffer, indexInBuffer + 1 == this.buffer.length ? 0 : indexInBuffer + 1);
        return (KType)previous;
    }

    private void removeBufferIndicesRange(int fromBufferIndex, int toBufferIndex) {
        int to;
        int bufLen = this.buffer.length;
        Object[] buffer = this.buffer;
        if (fromBufferIndex == toBufferIndex) {
            return;
        }
        long nbToBeRemoved = (long)toBufferIndex - (long)fromBufferIndex;
        if (nbToBeRemoved < 0L) {
            nbToBeRemoved += (long)bufLen;
        }
        int last = this.tail;
        long removed = 0L;
        int from = to = fromBufferIndex;
        while (from != last) {
            if (removed < nbToBeRemoved) {
                buffer[from] = null;
                ++removed;
            } else {
                buffer[to] = buffer[from];
                buffer[from] = null;
                to = to + 1 == bufLen ? 0 : to + 1;
            }
            from = from + 1 == bufLen ? 0 : from + 1;
        }
        this.tail = to;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int bufferPositionStart = this.indexToBufferPosition(fromIndex);
        int bufferPositionEndInclusive = this.indexToBufferPosition(toIndex - 1);
        this.removeBufferIndicesRange(bufferPositionStart, bufferPositionEndInclusive + 1 == this.buffer.length ? 0 : bufferPositionEndInclusive + 1);
    }

    private int bufferIndexToPosition(int bufferIndex) {
        int pos = -1;
        if (bufferIndex >= 0 && (pos = bufferIndex - this.head) < 0) {
            pos += this.buffer.length;
        }
        return pos;
    }

    private int indexToBufferPosition(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        long bufferPos = (long)index + (long)this.head;
        if (bufferPos >= (long)this.buffer.length) {
            bufferPos -= (long)this.buffer.length;
        }
        return (int)bufferPos;
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DescendingValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ObjectArrayDeque.this.tail;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index >= 1 ? this.cursor.index - 1 : ObjectArrayDeque.this.buffer.length - 1;
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ObjectArrayDeque.this.head >= 1 ? ObjectArrayDeque.this.head - 1 : ObjectArrayDeque.this.buffer.length - 1;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = this.cursor.index + 1 == ObjectArrayDeque.this.buffer.length ? 0 : this.cursor.index + 1;
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

