/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.FloatArrays;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatLongAssociativeContainer;
import com.carrotsearch.hppcrt.FloatLongMap;
import com.carrotsearch.hppcrt.FloatLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.cursors.FloatLongCursor;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatLongPredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.FloatLongProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.procedures.LongProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLongHashMap
implements FloatLongMap,
Cloneable {
    protected long defaultValue = 0L;
    public float[] keys;
    public long[] values;
    public boolean allocatedDefaultKey = false;
    public long allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<FloatLongCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = FloatLongHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public FloatLongHashMap() {
        this(8);
    }

    public FloatLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public FloatLongHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public FloatLongHashMap(FloatLongAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public long put(float key, long value) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                long oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(FloatLongAssociativeContainer container) {
        return this.putAll((Iterable<? extends FloatLongCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends FloatLongCursor> iterable) {
        int count = this.size();
        for (FloatLongCursor floatLongCursor : iterable) {
            this.put(floatLongCursor.key, floatLongCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(float key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(float key, long putValue, long incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public long addTo(float key, long incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(float pendingKey, long pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Float.floatToIntBits(pendingKey) != 0);
        float[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        float key = 0.0f;
        long value = 0L;
        int slot = -1;
        float[] keys = this.keys;
        long[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Float.floatToIntBits(key) == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Float.floatToIntBits(keys[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            float[] keys = new float[capacity];
            long[] values = new long[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public long remove(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                long value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        long[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            float existing = keys[slot];
            long existingValue = values[slot];
            if (Float.floatToIntBits(existing) == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0f;
        --this.assigned;
    }

    @Override
    public int removeAll(FloatContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof FloatLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0f)) {
                this.allocatedDefaultKey = false;
            }
            float[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (FloatCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatLongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys = this.keys;
        long[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public long get(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        float[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        FloatArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        float[] keys = this.keys;
        long[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FloatLongHashMap other = (FloatLongHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                FloatLongCursor c = (FloatLongCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                long otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends FloatLongProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0f, this.allocatedDefaultKeyValue);
        }
        float[] keys = this.keys;
        long[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            float existing = keys[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends FloatLongPredicate> T forEach(T predicate) {
        float existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        float[] keys = this.keys;
        long[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public FloatLongHashMap clone() {
        FloatLongHashMap cloned = new FloatLongHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static FloatLongHashMap from(float[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatLongHashMap map = new FloatLongHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static FloatLongHashMap from(FloatLongAssociativeContainer container) {
        return new FloatLongHashMap(container);
    }

    public static FloatLongHashMap newInstance() {
        return new FloatLongHashMap();
    }

    public static FloatLongHashMap newInstance(int initialCapacity, double loadFactor) {
        return new FloatLongHashMap(initialCapacity, loadFactor);
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == FloatLongHashMap.this.values.length + 1) {
                if (FloatLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatLongHashMap.this.values.length;
                    this.cursor.value = FloatLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatLongHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatLongHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractLongCollection {
        private final FloatLongHashMap owner;
        protected final IteratorPool<LongCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = FloatLongHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = FloatLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(long value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Float.floatToIntBits(keys[slot]) == 0 || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Float.floatToIntBits(keys[slot]) == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (Float.floatToIntBits(keys[slot]) == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(long e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Float.floatToIntBits(keys[slot]) != 0 && e == values[slot]) {
                    FloatLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Float.floatToIntBits(keys[slot]) != 0 && predicate.apply(values[slot])) {
                    FloatLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            float[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (Float.floatToIntBits(keys[i]) == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == FloatLongHashMap.this.keys.length + 1) {
                if (FloatLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatLongHashMap.this.keys.length;
                    this.cursor.value = 0.0f;
                    return this.cursor;
                }
                this.cursor.index = FloatLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatLongHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatLongHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatLongHashMap owner;
        protected final IteratorPool<FloatCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = FloatLongHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = FloatLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(float e) {
            return FloatLongHashMap.this.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0f);
            }
            float[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            float existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0f)) {
                return predicate;
            }
            float[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(float e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0f;
            }
            float[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                float existing = keys[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<FloatLongCursor> {
        public final FloatLongCursor cursor = new FloatLongCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatLongCursor fetch() {
            int i;
            if (this.cursor.index == FloatLongHashMap.this.keys.length + 1) {
                if (FloatLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatLongHashMap.this.keys.length;
                    this.cursor.key = 0.0f;
                    this.cursor.value = FloatLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatLongHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatLongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = FloatLongHashMap.this.keys[i];
            this.cursor.value = FloatLongHashMap.this.values[i];
            return this.cursor;
        }
    }
}

