/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;

public class ConcurrentOWLOntologyImpl
implements OWLMutableOntology,
HasTrimToSize {
    private final OWLOntology delegate;
    private final Lock readLock;
    private final Lock writeLock;

    @Inject
    public ConcurrentOWLOntologyImpl(@Nonnull OWLOntology delegate, @Nonnull ReadWriteLock readWriteLock) {
        this.delegate = (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)delegate);
        this.readLock = ((ReadWriteLock)OWLAPIPreconditions.verifyNotNull((Object)readWriteLock)).readLock();
        this.writeLock = ((ReadWriteLock)OWLAPIPreconditions.verifyNotNull((Object)readWriteLock)).writeLock();
    }

    @Override
    public void trimToSize() {
        this.writeLock.lock();
        try {
            if (this.delegate instanceof HasTrimToSize) {
                HasTrimToSize trimmableDelegate = (HasTrimToSize)this.delegate;
                trimmableDelegate.trimToSize();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void accept(@Nonnull OWLNamedObjectVisitor owlNamedObjectVisitor) {
        this.delegate.accept(owlNamedObjectVisitor);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLNamedObjectVisitorEx<O> owlNamedObjectVisitorEx) {
        return (O)this.delegate.accept(owlNamedObjectVisitorEx);
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public OWLOntologyManager getOWLOntologyManager() {
        this.readLock.lock();
        try {
            OWLOntologyManager oWLOntologyManager = this.delegate.getOWLOntologyManager();
            return oWLOntologyManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.writeLock.lock();
        try {
            this.delegate.setOWLOntologyManager(owlOntologyManager);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nonnull
    public OWLOntologyID getOntologyID() {
        this.readLock.lock();
        try {
            OWLOntologyID oWLOntologyID = this.delegate.getOntologyID();
            return oWLOntologyID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isAnonymous() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isAnonymous();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotation> getAnnotations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<IRI> getDirectImportsDocuments() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImportsDocuments();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLOntology> getDirectImports() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLOntology> getImports() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLOntology> getImportsClosure() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsClosure();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsDeclarations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getTBoxAxioms(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTBoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getABoxAxioms(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getABoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getRBoxAxioms(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getRBoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getGeneralClassAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEntity> getSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEntity> getSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isDeclared(@Nonnull OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeclared(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull IRI iri) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(iri);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OutputStream outputStream) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(outputStream);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull IRI iri) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, iri);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull OutputStream outputStream) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, outputStream);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlOntologyDocumentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, owlOntologyDocumentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClassExpression> getNestedClassExpressions() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNestedClassExpressions();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void accept(@Nonnull OWLObjectVisitor owlObjectVisitor) {
        this.delegate.accept(owlObjectVisitor);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> owlObjectVisitorEx) {
        return (O)this.delegate.accept(owlObjectVisitorEx);
    }

    public boolean isTopEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isTopEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isBottomEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isBottomEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int compareTo(OWLObject o) {
        this.readLock.lock();
        try {
            int n = this.delegate.compareTo((Object)o);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntitiesOfTypeInSignature(type);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports includeImportsClosure) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntitiesOfTypeInSignature(type, includeImportsClosure);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnonymousIndividuals();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClass> getClassesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getAxioms(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getAxiomCount(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getLogicalAxiomCount(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom, @Nonnull Imports imports, @Nonnull AxiomAnnotations axiomAnnotations) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom, imports, axiomAnnotations);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLAxiom> getAxioms(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public int getAxiomCount(boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public int getLogicalAxiomCount(boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType, boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(owlAxiom, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getLogicalAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(owlAxiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    @Deprecated
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClass> getClassesInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsDatatypeInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsEntityInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsClassInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsDataPropertyInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsIndividualInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<IRI> getPunnedIRIs(@Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getPunnedIRIs(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsReference(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsReference(@Nonnull OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLClass> getClassesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsEntityInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsClassInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsDataPropertyInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsDatatypeInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsIndividualInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsReference(@Nonnull OWLEntity owlEntity, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull Class<T> aClass, @Nonnull OWLObject owlObject, @Nonnull Imports imports, @Nonnull Navigation navigation) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(aClass, owlObject, imports, navigation);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T extends OWLAxiom> Collection<T> filterAxioms(@Nonnull OWLAxiomSearchFilter owlAxiomSearchFilter, @Nonnull Object o, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            Collection collection = this.delegate.filterAxioms(owlAxiomSearchFilter, o, imports);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(@Nonnull OWLAxiomSearchFilter owlAxiomSearchFilter, @Nonnull Object o, @Nonnull Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.contains(owlAxiomSearchFilter, o, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull Class<T> aClass, @Nonnull Class<? extends OWLObject> aClass1, @Nonnull OWLObject owlObject, @Nonnull Imports imports, @Nonnull Navigation navigation) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(aClass, aClass1, owlObject, imports, navigation);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubAnnotationPropertyOfAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyDomainAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyRangeAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(@Nonnull OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDeclarationAxioms(owlEntity);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(@Nonnull OWLAnnotationSubject owlAnnotationSubject) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(owlAnnotationSubject);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSubClass(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSuperClass(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentClassesAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointClassesAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointUnionAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(@Nonnull OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getHasKeyAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSubProperty(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSuperProperty(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyDomainAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyRangeAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentObjectPropertiesAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointObjectPropertiesAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseFunctionalObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSymmetricObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAsymmetricObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReflexiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIrreflexiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTransitiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSubProperty(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(@Nonnull OWLDataPropertyExpression owlDataPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSuperProperty(owlDataPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyDomainAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyRangeAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentDataPropertiesAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointDataPropertiesAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(@Nonnull OWLDataPropertyExpression owlDataPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalDataPropertyAxioms(owlDataPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(@Nonnull OWLClassExpression owlClassExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(owlClassExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeObjectPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeDataPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSameIndividualAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(@Nonnull OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDifferentIndividualAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(@Nonnull OWLDatatype owlDatatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypeDefinitions(owlDatatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nonnull
    public ChangeApplied applyChange(@Nonnull OWLOntologyChange owlOntologyChange) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().applyChange(owlOntologyChange);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nonnull
    public ChangeApplied applyChanges(@Nonnull List<? extends OWLOntologyChange> list) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().applyChanges(list);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> list) {
        this.writeLock.lock();
        try {
            ChangeDetails changeDetails = this.getMutableOntology().applyChangesAndGetDetails(list);
            return changeDetails;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nonnull
    public ChangeApplied addAxiom(@Nonnull OWLAxiom owlAxiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxiom(owlAxiom);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied addAxioms(@Nonnull Set<? extends OWLAxiom> set) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxioms(set);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }
}

