/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.isomorphism;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jgrapht.GraphMapping;
import org.jgrapht.alg.isomorphism.GraphOrdering;

public class IsomorphicGraphMapping<V, E>
implements GraphMapping<V, E> {
    GraphOrdering<V, E> g1;
    GraphOrdering<V, E> g2;
    int[] core1;
    int[] core2;

    public IsomorphicGraphMapping(GraphOrdering<V, E> g1, GraphOrdering<V, E> g2, int[] core1, int[] core2) {
        this.g1 = g1;
        this.g2 = g2;
        this.core1 = (int[])core1.clone();
        this.core2 = (int[])core2.clone();
    }

    @Override
    public V getVertexCorrespondence(V v, boolean forward) {
        int[] core;
        GraphOrdering<V, E> secondGraph;
        GraphOrdering<V, E> firstGraph;
        if (forward) {
            firstGraph = this.g1;
            secondGraph = this.g2;
            core = this.core1;
        } else {
            firstGraph = this.g2;
            secondGraph = this.g1;
            core = this.core2;
        }
        int vNumber = firstGraph.getVertexNumber(v);
        int uNumber = core[vNumber];
        if (uNumber == -1) {
            return null;
        }
        return secondGraph.getVertex(uNumber);
    }

    @Override
    public E getEdgeCorrespondence(E e, boolean forward) {
        int[] core;
        GraphOrdering<V, E> secondGraph;
        GraphOrdering<V, E> firstGraph;
        if (forward) {
            firstGraph = this.g1;
            secondGraph = this.g2;
            core = this.core1;
        } else {
            firstGraph = this.g2;
            secondGraph = this.g1;
            core = this.core2;
        }
        int[] eNumbers = firstGraph.getEdgeNumbers(e);
        if (core[eNumbers[0]] == -1 || core[eNumbers[1]] == -1) {
            return null;
        }
        return secondGraph.getEdge(core[eNumbers[0]], core[eNumbers[1]]);
    }

    public boolean hasVertexCorrespondence(V v) {
        return this.getVertexCorrespondence(v, true) != null;
    }

    public boolean hasEdgeCorrespondence(E e) {
        return this.getEdgeCorrespondence(e, true) != null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        Set<V> vertexSet = this.g1.getGraph().vertexSet();
        TreeMap<String, V> vertexMap = new TreeMap<String, V>();
        for (V v : vertexSet) {
            vertexMap.put(v.toString(), v);
        }
        int i = 0;
        for (Map.Entry entry : vertexMap.entrySet()) {
            Object u = this.getVertexCorrespondence(entry.getValue(), true);
            str.append(i++ == 0 ? "" : " ").append((String)entry.getKey()).append("=").append((Object)(u == null ? "~~" : u));
        }
        return str + "]";
    }

    public boolean isEqualMapping(GraphMapping<V, E> rel) {
        for (V v : this.g2.getGraph().vertexSet()) {
            if (this.getVertexCorrespondence(v, false).equals(rel.getVertexCorrespondence(v, false))) continue;
            return false;
        }
        return true;
    }
}

