/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.TSPAlgorithm;
import org.jgrapht.graph.GraphWalk;

public class HeldKarpTSP<V, E>
implements TSPAlgorithm<V, E> {
    private double memo(int previousNode, int state, double[][] C, double[][] W) {
        if (C[previousNode][state] != Double.MIN_VALUE) {
            return C[previousNode][state];
        }
        double totalCost = Double.MAX_VALUE;
        if (state == (1 << W.length) - 1) {
            totalCost = W[previousNode][0] != Double.MAX_VALUE ? W[previousNode][0] : Double.MAX_VALUE;
        } else {
            for (int i = 0; i < W.length; ++i) {
                if ((state >> i & 1) != 0 || W[previousNode][i] == Double.MAX_VALUE) continue;
                totalCost = Math.min(totalCost, W[previousNode][i] + this.memo(i, state ^ 1 << i, C, W));
            }
        }
        double d = totalCost;
        C[previousNode][state] = d;
        return d;
    }

    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        int n = graph.vertexSet().size();
        if (n == 0) {
            throw new IllegalArgumentException("Graph contains no vertices");
        }
        if (n > 31) {
            throw new IllegalArgumentException("The internal representation of the dynamic programming state space cannot represent graphs containing more than 31 vertices. The runtime complexity of this implementation, O(2^|V| x |V|^2),  makes it unsuitable for graphs with more than 31 vertices.");
        }
        if (n == 1) {
            V startNode = graph.vertexSet().iterator().next();
            return new GraphWalk<V, E>(graph, startNode, startNode, Collections.singletonList(startNode), null, 0.0);
        }
        double[][] W = new double[n][n];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(W[i], Double.MAX_VALUE);
        }
        HashMap<V, Integer> vertexMap = new HashMap<V, Integer>();
        ArrayList<V> indexList = new ArrayList<V>();
        for (E e : graph.edgeSet()) {
            V source = graph.getEdgeSource(e);
            V target = graph.getEdgeTarget(e);
            if (!vertexMap.containsKey(source)) {
                vertexMap.put(source, vertexMap.size());
                indexList.add(source);
            }
            if (!vertexMap.containsKey(target)) {
                vertexMap.put(target, vertexMap.size());
                indexList.add(target);
            }
            int u = (Integer)vertexMap.get(source);
            int v = (Integer)vertexMap.get(target);
            W[u][v] = Math.min(W[u][v], graph.getEdgeWeight(e));
            if (!graph.getType().isUndirected()) continue;
            W[v][u] = Math.min(W[v][u], graph.getEdgeWeight(e));
        }
        double[][] C = new double[n][1 << n];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(C[i], Double.MIN_VALUE);
        }
        double tourWeight = this.memo(0, 1, C, W);
        if (tourWeight == Double.MAX_VALUE) {
            return null;
        }
        ArrayList vertexList = new ArrayList(n);
        ArrayList<E> edgeList = new ArrayList<E>(n);
        int lastNode = 0;
        int lastState = 1;
        vertexList.add(indexList.get(lastNode));
        for (int step = 1; step < n; ++step) {
            int nextNode = -1;
            for (int node = 0; node < n; ++node) {
                if (C[node][lastState ^ 1 << node] + W[lastNode][node] != C[lastNode][lastState]) continue;
                nextNode = node;
                break;
            }
            assert (nextNode != -1);
            vertexList.add(indexList.get(nextNode));
            edgeList.add(graph.getEdge(indexList.get(lastNode), indexList.get(nextNode)));
            lastState ^= 1 << nextNode;
            lastNode = nextNode;
        }
        vertexList.add(indexList.get(0));
        edgeList.add(graph.getEdge(indexList.get(lastNode), indexList.get(0)));
        return new GraphWalk<V, E>(graph, indexList.get(0), indexList.get(0), vertexList, edgeList, tourWeight);
    }
}

