/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public class BrownBacktrackColoring<V, E> {
    private final List<V> _vertices;
    private final int[][] _neighbors;
    private final Map<V, Integer> _vertexToPos;
    private int[] _color;
    private int[] _colorCount;
    private BitSet[] _allowedColors;
    private int _chi;

    public BrownBacktrackColoring(Graph<V, E> g) {
        int numVertices = g.vertexSet().size();
        this._vertices = new ArrayList<V>(numVertices);
        this._neighbors = new int[numVertices][];
        this._vertexToPos = new HashMap<V, Integer>(numVertices);
        for (V vertex : g.vertexSet()) {
            this._neighbors[this._vertices.size()] = new int[g.edgesOf(vertex).size()];
            this._vertexToPos.put((Integer)vertex, this._vertices.size());
            this._vertices.add(vertex);
        }
        for (int i = 0; i < numVertices; ++i) {
            int nbIndex = 0;
            V vertex = this._vertices.get(i);
            for (E e : g.edgesOf(vertex)) {
                this._neighbors[i][nbIndex++] = this._vertexToPos.get(Graphs.getOppositeVertex(g, e, vertex));
            }
        }
    }

    void recursiveColor(int pos) {
        int i;
        this._colorCount[pos] = this._colorCount[pos - 1];
        this._allowedColors[pos].set(0, this._colorCount[pos] + 1);
        for (i = 0; i < this._neighbors[pos].length; ++i) {
            int nb = this._neighbors[pos][i];
            if (this._color[nb] <= 0) continue;
            this._allowedColors[pos].clear(this._color[nb]);
        }
        for (i = 1; i <= this._colorCount[pos] && this._colorCount[pos] < this._chi; ++i) {
            if (!this._allowedColors[pos].get(i)) continue;
            this._color[pos] = i;
            if (pos < this._neighbors.length - 1) {
                this.recursiveColor(pos + 1);
                continue;
            }
            this._chi = this._colorCount[pos];
        }
        if (this._colorCount[pos] + 1 < this._chi) {
            int n = pos;
            this._colorCount[n] = this._colorCount[n] + 1;
            this._color[pos] = this._colorCount[pos];
            if (pos < this._neighbors.length - 1) {
                this.recursiveColor(pos + 1);
            } else {
                this._chi = this._colorCount[pos];
            }
        }
        this._color[pos] = 0;
    }

    public Integer getResult(Map<V, Integer> additionalData) {
        int i;
        this._chi = this._neighbors.length;
        this._color = new int[this._neighbors.length];
        this._color[0] = 1;
        this._colorCount = new int[this._neighbors.length];
        this._colorCount[0] = 1;
        this._allowedColors = new BitSet[this._neighbors.length];
        for (i = 0; i < this._neighbors.length; ++i) {
            this._allowedColors[i] = new BitSet(1);
        }
        this.recursiveColor(1);
        if (additionalData != null) {
            for (i = 0; i < this._vertices.size(); ++i) {
                additionalData.put((Integer)this._vertices.get(i), this._color[i]);
            }
        }
        return this._chi;
    }
}

