/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;
import org.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import org.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import org.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import org.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.util.TypeUtil;

public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3582386521833998627L;
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    private static final String GRAPH_SPECIFICS_MUST_NOT_BE_NULL = "Graph specifics must not be null";
    private transient Set<V> unmodifiableVertexSet = null;
    private Supplier<V> vertexSupplier;
    private Supplier<E> edgeSupplier;
    @Deprecated
    private EdgeFactory<V, E> edgeFactory;
    private GraphType type;
    private Specifics<V, E> specifics;
    private IntrusiveEdgesSpecifics<V, E> intrusiveEdgesSpecifics;

    protected AbstractBaseGraph(Supplier<V> vertexSupplier, Supplier<E> edgeSupplier, GraphType type) {
        this.vertexSupplier = vertexSupplier;
        this.edgeSupplier = edgeSupplier;
        this.type = Objects.requireNonNull(type);
        if (type.isMixed()) {
            throw new IllegalArgumentException("Mixed graph not supported");
        }
        this.specifics = Objects.requireNonNull(this.createSpecifics(type.isDirected()), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
        this.intrusiveEdgesSpecifics = Objects.requireNonNull(this.createIntrusiveEdgesSpecifics(type.isWeighted()), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
        this.edgeFactory = new BackwardsCompatibleEdgeFactory(null);
    }

    @Deprecated
    protected AbstractBaseGraph(EdgeFactory<V, E> ef, boolean directed, boolean allowMultipleEdges, boolean allowLoops, boolean weighted) {
        this(null, null, new DefaultGraphType.Builder(directed, !directed).allowMultipleEdges(allowMultipleEdges).allowSelfLoops(allowLoops).weighted(weighted).build());
        this.edgeFactory = new BackwardsCompatibleEdgeFactory(ef);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        return this.specifics.getAllEdges(sourceVertex, targetVertex);
    }

    @Deprecated
    public boolean isAllowingLoops() {
        return this.type.isAllowingSelfLoops();
    }

    @Deprecated
    public boolean isAllowingMultipleEdges() {
        return this.type.isAllowingMultipleEdges();
    }

    @Deprecated
    public boolean isWeighted() {
        return this.type.isWeighted();
    }

    @Deprecated
    public boolean isDirected() {
        return this.type.isDirected();
    }

    @Override
    @Deprecated
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public Supplier<E> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public void setEdgeSupplier(Supplier<E> edgeSupplier) {
        this.edgeSupplier = edgeSupplier;
    }

    @Override
    public Supplier<V> getVertexSupplier() {
        return this.vertexSupplier;
    }

    public void setVertexSupplier(Supplier<V> vertexSupplier) {
        this.vertexSupplier = vertexSupplier;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        return this.specifics.getEdge(sourceVertex, targetVertex);
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.type.isAllowingMultipleEdges() && this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!this.type.isAllowingSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        E e = this.edgeFactory.createEdge(sourceVertex, targetVertex);
        if (this.intrusiveEdgesSpecifics.add(e, sourceVertex, targetVertex)) {
            this.specifics.addEdgeToTouchingVertices(e);
            return e;
        }
        return null;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.type.isAllowingMultipleEdges() && this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!this.type.isAllowingSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        if (this.intrusiveEdgesSpecifics.add(e, sourceVertex, targetVertex)) {
            this.specifics.addEdgeToTouchingVertices(e);
            return true;
        }
        return false;
    }

    @Override
    public V addVertex() {
        if (this.vertexSupplier == null) {
            throw new UnsupportedOperationException("The graph contains no vertex supplier");
        }
        V v = this.vertexSupplier.get();
        if (this.specifics.addVertex(v)) {
            return v;
        }
        return null;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.specifics.addVertex(v);
        return true;
    }

    @Override
    public V getEdgeSource(E e) {
        return this.intrusiveEdgesSpecifics.getEdgeSource(e);
    }

    @Override
    public V getEdgeTarget(E e) {
        return this.intrusiveEdgesSpecifics.getEdgeTarget(e);
    }

    public Object clone() {
        try {
            AbstractBaseGraph newGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.edgeFactory = this.edgeFactory;
            newGraph.unmodifiableVertexSet = null;
            newGraph.specifics = newGraph.createSpecifics(this.getType().isDirected());
            newGraph.intrusiveEdgesSpecifics = newGraph.createIntrusiveEdgesSpecifics(this.getType().isWeighted());
            Graphs.addGraph(newGraph, this);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean containsEdge(E e) {
        return this.intrusiveEdgesSpecifics.containsEdge(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.specifics.getVertexSet().contains(v);
    }

    @Override
    public int degreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.degreeOf(vertex);
    }

    @Override
    public Set<E> edgeSet() {
        return this.intrusiveEdgesSpecifics.getEdgeSet();
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.edgesOf(vertex);
    }

    @Override
    public int inDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.inDegreeOf(vertex);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.incomingEdgesOf(vertex);
    }

    @Override
    public int outDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outDegreeOf(vertex);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outgoingEdgesOf(vertex);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.intrusiveEdgesSpecifics.remove(e);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.containsEdge(e)) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.intrusiveEdgesSpecifics.remove(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set<E> touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList<E>(touchingEdgesList));
            this.specifics.getVertexSet().remove(v);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.intrusiveEdgesSpecifics.getEdgeWeight(e);
    }

    @Override
    public void setEdgeWeight(E e, double weight) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.intrusiveEdgesSpecifics.setEdgeWeight(e, weight);
    }

    @Override
    public GraphType getType() {
        return this.type;
    }

    protected Specifics<V, E> createSpecifics(boolean directed) {
        if (directed) {
            return new FastLookupDirectedSpecifics(this);
        }
        return new FastLookupUndirectedSpecifics(this);
    }

    protected IntrusiveEdgesSpecifics<V, E> createIntrusiveEdgesSpecifics(boolean weighted) {
        if (weighted) {
            return new WeightedIntrusiveEdgesSpecifics();
        }
        return new UniformIntrusiveEdgesSpecifics();
    }

    @Deprecated
    private class BackwardsCompatibleEdgeFactory
    implements EdgeFactory<V, E>,
    Serializable {
        private EdgeFactory<V, E> ef;

        public BackwardsCompatibleEdgeFactory(EdgeFactory<V, E> ef) {
            this.ef = ef;
        }

        @Override
        public E createEdge(V sourceVertex, V targetVertex) {
            if (AbstractBaseGraph.this.edgeSupplier == null && this.ef == null) {
                throw new UnsupportedOperationException("The graph contains no edge supplier");
            }
            if (AbstractBaseGraph.this.edgeSupplier != null) {
                return AbstractBaseGraph.this.edgeSupplier.get();
            }
            return this.ef.createEdge(sourceVertex, targetVertex);
        }
    }
}

