/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.dataformat.protobuf.ByteAccumulator;
import com.fasterxml.jackson.dataformat.protobuf.PackageVersion;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufUtil;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufWriteContext;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldType;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufMessage;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class ProtobufGenerator
extends GeneratorBase {
    protected static final JsonWriteContext BOGUS_WRITE_CONTEXT = JsonWriteContext.createRootContext(null);
    protected static final ProtobufField UNKNOWN_FIELD = ProtobufField.unknownField();
    protected static final ProtobufMessage UNKNOWN_MESSAGE = ProtobufMessage.bogusMessage("<unknown>");
    protected final IOContext _ioContext;
    protected ProtobufSchema _schema;
    protected ProtobufWriteContext _rootContext;
    protected boolean _inObject;
    protected boolean _writeTag;
    protected boolean _complete;
    protected ProtobufMessage _currMessage;
    protected ProtobufField _currField;
    protected final OutputStream _output;
    protected ByteAccumulator _buffered;
    protected ProtobufWriteContext _pbContext;
    protected byte[] _currBuffer;
    protected int _currStart;
    protected int _currPtr;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public ProtobufGenerator(IOContext ctxt, int jsonFeatures, ObjectCodec codec, OutputStream output) throws IOException {
        super(jsonFeatures, codec, BOGUS_WRITE_CONTEXT);
        this._ioContext = ctxt;
        this._output = output;
        this._pbContext = this._rootContext = ProtobufWriteContext.createNullContext();
        this._currBuffer = ctxt.allocWriteEncodingBuffer();
    }

    public void setSchema(ProtobufSchema schema) {
        if (this._schema == schema) {
            return;
        }
        this._schema = schema;
        this._pbContext = this._rootContext = ProtobufWriteContext.createRootContext(schema.getRootType());
    }

    public Object getCurrentValue() {
        return this._pbContext.getCurrentValue();
    }

    public void setCurrentValue(Object v) {
        this._pbContext.setCurrentValue(v);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ProtobufGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public ProtobufGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._output;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof ProtobufSchema;
    }

    public ProtobufSchema getSchema() {
        return this._schema;
    }

    public void setSchema(FormatSchema schema) {
        if (!(schema instanceof ProtobufSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + schema.getClass().getName());
        }
        this.setSchema((ProtobufSchema)schema);
    }

    public final void writeFieldName(String name) throws IOException {
        ProtobufField f;
        if (!this._inObject) {
            this._reportError("Can not write field name: current context not an OBJECT but " + this._pbContext.getTypeDesc());
        }
        if ((f = this._currField) != null && this._pbContext.notArray()) {
            if ((f = f.nextIf(name)) == null) {
                f = this._currMessage.field(name);
            }
        } else {
            f = this._currMessage.firstIf(name);
        }
        if (f == null) {
            if (this._currMessage == UNKNOWN_MESSAGE || this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                f = UNKNOWN_FIELD;
            } else {
                this._reportError("Unrecognized field '" + name + "' (in Message of type " + this._currMessage.getName() + "); known fields are: " + this._currMessage.fieldsAsString());
            }
        }
        this._pbContext.setField(f);
        this._currField = f;
    }

    public final void writeFieldName(SerializableString sstr) throws IOException {
        if (!this._inObject) {
            this._reportError("Can not write field name: current context not an OBJECT but " + this._pbContext.getTypeDesc());
        }
        ProtobufField f = this._currField;
        String name = sstr.getValue();
        if (f != null && this._pbContext.notArray()) {
            if ((f = f.nextIf(name)) == null) {
                f = this._currMessage.field(name);
            }
        } else {
            f = this._currMessage.firstIf(name);
        }
        if (f == null) {
            if (this._currMessage == UNKNOWN_MESSAGE || this.isEnabled(JsonGenerator.Feature.IGNORE_UNKNOWN)) {
                f = UNKNOWN_FIELD;
            } else {
                this._reportError("Unrecognized field '" + name + "' (in Message of type " + this._currMessage.getName() + "); known fields are: " + this._currMessage.fieldsAsString());
            }
        }
        this._pbContext.setField(f);
        this._currField = f;
    }

    public final void flush() throws IOException {
        int start;
        int len;
        if (this._buffered == null && (len = this._currPtr - (start = this._currStart)) > 0) {
            this._currStart = 0;
            this._currPtr = 0;
            this._output.write(this._currBuffer, start, len);
        }
        this._output.flush();
    }

    public void close() throws IOException {
        super.close();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            ProtobufWriteContext ctxt;
            while ((ctxt = this._pbContext) != null) {
                if (ctxt.inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        if (!this._complete) {
            this._complete();
        }
        if (this._output != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._output.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._output.flush();
            }
        }
        this._releaseBuffers();
    }

    public final void writeStartArray() throws IOException {
        if (!this._inObject) {
            this._reportError("Current context not an OBJECT, can not write arrays");
        }
        if (this._currField == null) {
            this._reportError("Can not write START_ARRAY without field (message type " + this._currMessage.getName() + ")");
        }
        if (!this._currField.isArray()) {
            this._reportError("Can not write START_ARRAY: field '" + this._currField.name + "' not declared as 'repeated'");
        }
        this._pbContext = this._pbContext.createChildArrayContext();
        boolean bl = this._writeTag = !this._currField.packed;
        if (!this._writeTag) {
            this._startBuffering(this._currField.typedTag);
        }
    }

    public final void writeEndArray() throws IOException {
        if (!this._pbContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._pbContext.getTypeDesc());
        }
        this._pbContext = this._pbContext.getParent();
        if (this._pbContext.inRoot()) {
            if (!this._complete) {
                this._complete();
            }
            this._inObject = false;
        } else {
            this._inObject = this._pbContext.inObject();
        }
        this._writeTag = true;
        if (this._currField.packed) {
            this._finishBuffering();
        }
    }

    public final void writeStartObject() throws IOException {
        if (this._currField == null) {
            if (!this._pbContext.inRoot()) {
                this._reportError("Can not write START_OBJECT without field (message type " + this._currMessage.getName() + ")");
            }
            this._currMessage = this._schema.getRootType();
        } else {
            if (!this._currField.isObject) {
                this._reportError("Can not write START_OBJECT: type of field '" + this._currField.name + "' not Message but: " + (Object)((Object)this._currField.type));
            }
            this._currMessage = this._currField.getMessageType();
            if (this._writeTag) {
                this._startBuffering(this._currField.typedTag);
            } else {
                this._startBuffering();
            }
        }
        if (this._inObject) {
            this._pbContext = this._pbContext.createChildObjectContext(this._currMessage);
            this._currField = null;
        } else {
            this._pbContext = this._pbContext.createChildObjectContext(this._currMessage);
            this._inObject = true;
        }
        this._writeTag = true;
    }

    public final void writeEndObject() throws IOException {
        boolean inObj;
        if (!this._inObject) {
            this._reportError("Current context not an object but " + this._pbContext.getTypeDesc());
        }
        this._pbContext = this._pbContext.getParent();
        if (this._pbContext.inRoot()) {
            if (!this._complete) {
                this._complete();
            }
        } else {
            this._currMessage = this._pbContext.getMessageType();
        }
        this._currField = this._pbContext.getField();
        this._inObject = inObj = this._pbContext.inObject();
        boolean bl = this._writeTag = inObj || !this._pbContext.inArray() || !this._currField.packed;
        if (this._buffered != null) {
            this._finishBuffering();
        }
    }

    public void writeString(String text) throws IOException {
        int c;
        int ptr;
        if (text == null) {
            this.writeNull();
            return;
        }
        if (this._currField.wireType != 2) {
            this._writeEnum(text);
            return;
        }
        int clen = text.length();
        if (clen > 99) {
            this._encodeLongerString(text);
            return;
        }
        if (clen == 0) {
            this._writeEmptyString();
            return;
        }
        this._verifyValueWrite();
        this._ensureRoom(clen + clen + clen + 7);
        int start = ptr = this._writeTag(this._currPtr) + 1;
        byte[] buf = this._currBuffer;
        int i = 0;
        while ((c = text.charAt(i)) <= 127) {
            buf[ptr++] = (byte)c;
            if (++i < clen) continue;
            buf[start - 1] = (byte)(ptr - start);
            this._currPtr = ptr;
            return;
        }
        while (i < clen) {
            if ((c = text.charAt(i++)) <= 127) {
                buf[ptr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[ptr++] = (byte)(0xC0 | c >> 6);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                buf[ptr++] = (byte)(0xE0 | c >> 12);
                buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (i >= clen) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._decodeSurrogate(c, text.charAt(i++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            buf[ptr++] = (byte)(0xF0 | c >> 18);
            buf[ptr++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c & 0x3F);
        }
        int blen = ptr - start;
        if (blen <= 127) {
            buf[start - 1] = (byte)blen;
        } else {
            System.arraycopy(buf, start, buf, start + 1, blen);
            buf[start - 1] = (byte)(128 + (blen & 0x7F));
            buf[start] = (byte)(blen >> 7);
            ++ptr;
        }
        this._currPtr = ptr;
    }

    public void writeString(char[] text, int offset, int clen) throws IOException {
        int c;
        int ptr;
        if (text == null) {
            this.writeNull();
            return;
        }
        if (this._currField.wireType != 2) {
            this._writeEnum(new String(text, offset, clen));
        }
        if (clen > 99) {
            this._encodeLongerString(text, offset, clen);
            return;
        }
        if (clen == 0) {
            this._writeEmptyString();
            return;
        }
        this._verifyValueWrite();
        this._ensureRoom(clen + clen + clen + 7);
        int start = ptr = this._writeTag(this._currPtr) + 1;
        byte[] buf = this._currBuffer;
        int end = offset + clen;
        while ((c = text[offset]) <= 127) {
            buf[ptr++] = (byte)c;
            if (++offset < end) continue;
            buf[start - 1] = (byte)(ptr - start);
            this._currPtr = ptr;
            return;
        }
        while (offset < end) {
            if ((c = text[offset++]) <= 127) {
                buf[ptr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[ptr++] = (byte)(0xC0 | c >> 6);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                buf[ptr++] = (byte)(0xE0 | c >> 12);
                buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (offset >= end) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._decodeSurrogate(c, text[offset++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            buf[ptr++] = (byte)(0xF0 | c >> 18);
            buf[ptr++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c & 0x3F);
        }
        int blen = ptr - start;
        if (blen <= 127) {
            buf[start - 1] = (byte)blen;
        } else {
            System.arraycopy(buf, start, buf, start + 1, blen);
            buf[start - 1] = (byte)(128 + (blen & 0x7F));
            buf[start] = (byte)(blen >> 7);
            ++ptr;
        }
        this._currPtr = ptr;
    }

    public final void writeString(SerializableString sstr) throws IOException {
        this._verifyValueWrite();
        if (this._currField.wireType == 2) {
            byte[] b = sstr.asUnquotedUTF8();
            this._writeLengthPrefixed(b, 0, b.length);
        } else if (this._currField.type == FieldType.ENUM) {
            int index = this._currField.findEnumIndex(sstr);
            if (index < 0) {
                this._reportEnumError(sstr);
            }
            this._writeEnum(index);
        } else {
            this._reportWrongWireType("string");
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("string");
            return;
        }
        this._verifyValueWrite();
        this._writeLengthPrefixed(text, offset, len);
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("string");
            return;
        }
        this._verifyValueWrite();
        this._writeLengthPrefixed(text, offset, len);
    }

    protected void _writeEmptyString() throws IOException {
        this._verifyValueWrite();
        this._ensureRoom(6);
        this._currPtr = this._writeTag(this._currPtr);
        this._currBuffer[this._currPtr++] = 0;
    }

    protected void _writeEnum(String str) throws IOException {
        int index;
        if (this._currField.type != FieldType.ENUM) {
            this._reportWrongWireType("string");
        }
        if ((index = this._currField.findEnumIndex(str)) < 0) {
            this._reportEnumError(str);
        }
        int tag = this._currField.typedTag;
        int ptr = this._currPtr;
        if (index > 127 || tag > 127 || this._currPtr + 1 >= this._currBuffer.length) {
            this._writeVInt(index);
            return;
        }
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)tag;
        buf[ptr++] = (byte)index;
        this._currPtr = ptr;
    }

    protected void _writeEnum(int index) throws IOException {
        int tag = this._currField.typedTag;
        int ptr = this._currPtr;
        if (index > 127 || tag > 127 || this._currPtr + 1 >= this._currBuffer.length) {
            this._writeVInt(index);
            return;
        }
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)tag;
        buf[ptr++] = (byte)index;
        this._currPtr = ptr;
    }

    protected void _reportEnumError(Object enumValue) throws IOException {
        this._reportErrorF("No Enum '%s' found for property '%s'; valid values = %s" + this._currField.getEnumValues(), this._currField.name, enumValue);
    }

    public void writeRaw(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite();
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("binary");
            return;
        }
        this._ensureRoom(10);
        this._writeLengthPrefixed(data, offset, len);
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            int b = this._currField.usesZigZag ? (state ? 2 : 0) : (state ? 1 : 0);
            this._writeVInt(b);
            return;
        }
        if (type == 5) {
            this._writeInt32(state ? 1 : 0);
            return;
        }
        if (type == 1) {
            this._writeInt64(state ? 1L : 0L);
            return;
        }
        this._reportWrongWireType("boolean");
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite();
        if (this._currField == UNKNOWN_FIELD) {
            return;
        }
        if (this._currField.required) {
            this._reportError("Can not omit writing of `null` value for required field '" + this._currField.name + "' (type " + (Object)((Object)this._currField.type) + ")");
        }
    }

    public void writeNumber(int v) throws IOException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            if (this._currField.usesZigZag) {
                v = ProtobufUtil.zigzagEncode(v);
            }
            this._writeVInt(v);
            return;
        }
        if (type == 5) {
            this._writeInt32(v);
            return;
        }
        if (type == 1) {
            this._writeInt64(v);
            return;
        }
        this._reportWrongWireType("int");
    }

    public void writeNumber(long v) throws IOException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            if (this._currField.usesZigZag) {
                v = ProtobufUtil.zigzagEncode(v);
            }
            this._writeVLong(v);
            return;
        }
        if (type == 5) {
            this._writeInt32((int)v);
            return;
        }
        if (type == 1) {
            this._writeInt64(v);
            return;
        }
        this._reportWrongWireType("long");
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        if (this._currField == UNKNOWN_FIELD) {
            return;
        }
        this.writeNumber(v.longValue());
    }

    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 5) {
            float f = (float)d;
            this._writeInt32(Float.floatToRawIntBits(f));
            return;
        }
        if (type == 1) {
            this._writeInt64(Double.doubleToLongBits(d));
            return;
        }
        if (this._currField.type == FieldType.STRING) {
            this._encodeLongerString(String.valueOf(d));
            return;
        }
        this._reportWrongWireType("double");
    }

    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 5) {
            this._writeInt32(Float.floatToRawIntBits(f));
            return;
        }
        if (type == 1) {
            this._writeInt64(Double.doubleToLongBits(f));
            return;
        }
        if (this._currField.type == FieldType.STRING) {
            this._encodeLongerString(String.valueOf(f));
            return;
        }
        this._reportWrongWireType("float");
    }

    public void writeNumber(BigDecimal v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        if (this._currField == UNKNOWN_FIELD) {
            return;
        }
        this.writeNumber(v.doubleValue());
    }

    public void writeNumber(String encodedValue) throws IOException {
        throw new UnsupportedOperationException("Can not write 'untyped' numbers");
    }

    protected final void _verifyValueWrite() throws IOException {
        if (this._currField == null) {
            this._reportError("Can not write value without indicating field first (in message of type " + this._currMessage.getName() + ")");
        }
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        this._throwInternal();
    }

    protected void _releaseBuffers() {
        byte[] b = this._currBuffer;
        if (b != null) {
            this._ioContext.releaseWriteEncodingBuffer(b);
            this._currBuffer = null;
        }
    }

    protected void _encodeLongerString(char[] text, int offset, int clen) throws IOException {
        this._verifyValueWrite();
        byte[] b = new String(text, offset, clen).getBytes(UTF8);
        this._writeLengthPrefixed(b, 0, b.length);
    }

    protected void _encodeLongerString(String text) throws IOException {
        byte[] b = text.getBytes(UTF8);
        this._writeLengthPrefixed(b, 0, b.length);
    }

    protected void _writeLengthPrefixed(byte[] data, int offset, int len) throws IOException {
        int ptr = this._writeTag(this._currPtr);
        ptr = ProtobufUtil.appendLengthLength(len, this._currBuffer, ptr);
        while (len > 0) {
            int max = Math.min(len, this._currBuffer.length - ptr);
            System.arraycopy(data, offset, this._currBuffer, ptr, max);
            ptr += max;
            if ((len -= max) == 0) {
                this._currPtr = ptr;
                break;
            }
            offset += max;
            ByteAccumulator acc = this._buffered;
            int start = this._currStart;
            this._currStart = 0;
            int toFlush = ptr - start;
            ptr = 0;
            if (acc == null) {
                if (toFlush > 0) {
                    this._output.write(this._currBuffer, start, toFlush);
                }
                ptr = 0;
                continue;
            }
            if (toFlush > 0) {
                acc.append(this._currBuffer, start, toFlush);
            }
            this._currBuffer = ProtobufUtil.allocSecondary(this._currBuffer);
        }
    }

    private final void _writeVInt(int v) throws IOException {
        this._ensureRoom(10);
        int ptr = this._writeTag(this._currPtr);
        if (v < 0) {
            this._currPtr = this._writeVIntMax(v, ptr);
            return;
        }
        byte[] buf = this._currBuffer;
        if (v <= 127) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)(128 + (v & 0x7F));
            if ((v >>= 7) <= 127) {
                buf[ptr++] = (byte)v;
            } else {
                buf[ptr++] = (byte)((v & 0x7F) + 128);
                if ((v >>= 7) <= 127) {
                    buf[ptr++] = (byte)v;
                } else {
                    buf[ptr++] = (byte)((v & 0x7F) + 128);
                    if ((v >>= 7) <= 127) {
                        buf[ptr++] = (byte)v;
                    } else {
                        buf[ptr++] = (byte)((v & 0x7F) + 128);
                        buf[ptr++] = (byte)((v >>= 7) & 0x7F);
                    }
                }
            }
        }
        this._currPtr = ptr;
    }

    private final int _writeVIntMax(int v, int ptr) throws IOException {
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)((v & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(v >>= 7);
        return ptr;
    }

    private final void _writeVLong(long v) throws IOException {
        this._ensureRoom(16);
        int ptr = this._writeTag(this._currPtr);
        if (v < 0L) {
            this._currPtr = this._writeVLongMax(v, ptr);
            return;
        }
        if (v <= 0xFFFFFFFL) {
            int i = (int)v;
            byte[] buf = this._currBuffer;
            if (v <= 127L) {
                buf[ptr++] = (byte)v;
            } else {
                do {
                    buf[ptr++] = (byte)((i & 0x7F) + 128);
                } while ((i >>= 7) > 127);
                buf[ptr++] = (byte)i;
            }
            this._currPtr = ptr;
            return;
        }
        int i = (int)v;
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        if ((v >>>= 28) <= 127L) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)((v & 0x7FL) + 128L);
            i = (int)(v >> 7);
            do {
                buf[ptr++] = (byte)((i & 0x7F) + 128);
            } while ((i >>= 7) > 127);
            buf[ptr++] = (byte)i;
        }
        this._currPtr = ptr;
    }

    private final int _writeVLongMax(long v, int ptr) throws IOException {
        byte[] buf = this._currBuffer;
        int i = (int)v;
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        i = (int)(v >>> 28);
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        i = (int)(v >>> 56);
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(i >>= 7);
        return ptr;
    }

    private final void _writeInt32(int v) throws IOException {
        this._ensureRoom(9);
        int ptr = this._writeTag(this._currPtr);
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final void _writeInt64(long v64) throws IOException {
        this._ensureRoom(13);
        int ptr = this._writeTag(this._currPtr);
        byte[] buf = this._currBuffer;
        int v = (int)v64;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        v = (int)(v64 >> 32);
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final int _writeTag(int ptr) {
        if (this._writeTag) {
            byte[] buf = this._currBuffer;
            int tag = this._currField.typedTag;
            if (tag <= 127) {
                buf[ptr++] = (byte)tag;
            } else {
                do {
                    buf[ptr++] = (byte)((tag & 0x7F) + 128);
                } while ((tag >>= 7) > 127);
                buf[ptr++] = (byte)tag;
            }
        }
        return ptr;
    }

    private final void _startBuffering(int typedTag) throws IOException {
        int start;
        int len;
        this._ensureRoom(20);
        int ptr = this._currPtr;
        if (this._buffered == null && (len = ptr - (start = this._currStart)) > 0) {
            ptr = 0;
            this._output.write(this._currBuffer, start, len);
        }
        this._currStart = this._currPtr = ptr + 10;
        this._buffered = new ByteAccumulator(this._buffered, typedTag, this._currBuffer, ptr);
    }

    private final void _startBuffering() throws IOException {
        int len;
        this._ensureRoom(16);
        int ptr = this._currPtr;
        if (this._buffered == null && (len = ptr - this._currStart) > 0) {
            ptr = 0;
            this._output.write(this._currBuffer, this._currStart, len);
        }
        this._currStart = this._currPtr = ptr + 5;
        this._buffered = new ByteAccumulator(this._buffered, this._currBuffer, ptr);
    }

    private final void _finishBuffering() throws IOException {
        int start = this._currStart;
        int currLen = this._currPtr - start;
        ByteAccumulator acc = this._buffered;
        this._buffered = acc = acc.finish(this._output, this._currBuffer, start, currLen);
        if (acc == null) {
            this._currStart = 0;
            this._currPtr = 0;
        } else {
            this._currStart = this._currPtr;
        }
    }

    protected final void _ensureRoom(int needed) throws IOException {
        if (this._currPtr + needed <= this._currBuffer.length) {
            return;
        }
        int start = this._currStart;
        int currLen = this._currPtr - start;
        this._currStart = 0;
        this._currPtr = 0;
        ByteAccumulator acc = this._buffered;
        if (acc == null) {
            if (currLen > 0) {
                this._output.write(this._currBuffer, start, currLen);
            }
            return;
        }
        if (currLen > 0) {
            acc.append(this._currBuffer, start, currLen);
        }
        this._currBuffer = ProtobufUtil.allocSecondary(this._currBuffer);
    }

    protected void _complete() throws IOException {
        this._complete = true;
        int start = this._currStart;
        int currLen = this._currPtr - start;
        this._currPtr = start;
        ByteAccumulator acc = this._buffered;
        if (acc == null) {
            if (currLen > 0) {
                this._output.write(this._currBuffer, start, currLen);
                this._currStart = 0;
                this._currPtr = 0;
            }
        } else {
            for (acc = acc.finish(this._output, this._currBuffer, start, currLen); acc != null; acc = acc.finish(this._output)) {
            }
            this._buffered = null;
        }
    }

    protected void _reportWrongWireType(String typeStr) throws IOException {
        if (this._currField == UNKNOWN_FIELD) {
            return;
        }
        this._reportErrorF("Can not write `string` value for '%s' (type %s)", new Object[]{this._currField.name, this._currField.type});
    }

    private void _reportErrorF(String format, Object ... args) throws JsonGenerationException {
        this._reportError(String.format(format, args));
    }

    private void _throwIllegalSurrogate(int code) {
        if (code > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (code >= 55296) {
            if (code <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output");
    }
}

