/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.DataType;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.FieldElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.MessageElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.AnnotationBasedTagGenerator;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefaultTagGenerator;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.ProtobuffSchemaHelper;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TagGenerator;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MessageElementVisitor
extends JsonObjectFormatVisitor.Base
implements TypeElementBuilder {
    protected MessageElement.Builder _builder;
    protected TagGenerator _tagGenerator;
    protected JavaType _type;
    protected Set<JavaType> _nestedTypes = new HashSet<JavaType>();
    protected DefinedTypeElementBuilders _definedTypeElementBuilders;

    public MessageElementVisitor(SerializerProvider provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        super(provider);
        this._definedTypeElementBuilders = definedTypeElementBuilders;
        this._type = type;
        this._builder = MessageElement.builder();
        this._builder.name(type.getRawClass().getSimpleName());
        this._builder.documentation("Message for " + type.toCanonical());
        this._definedTypeElementBuilders.AddTypeElement(type, this, isNested);
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        FieldElement fElement = this.buildFieldElement(writer, FieldElement.Label.REQUIRED);
        this._builder.addField(fElement);
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        FieldElement fElement = this.buildFieldElement(writer, FieldElement.Label.OPTIONAL);
        this._builder.addField(fElement);
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
    }

    protected FieldElement buildFieldElement(BeanProperty writer, FieldElement.Label label) throws JsonMappingException {
        FieldElement.Builder fBuilder = FieldElement.builder();
        fBuilder.name(writer.getName());
        fBuilder.tag(this.nextTag(writer));
        JavaType type = writer.getType();
        if (type.isArrayType() || type.isCollectionLikeType()) {
            fBuilder.label(FieldElement.Label.REPEATED);
            fBuilder.type(this.getDataType(type.getContentType()));
        } else {
            fBuilder.label(label);
            fBuilder.type(this.getDataType(type));
        }
        return fBuilder.build();
    }

    protected int nextTag(BeanProperty writer) {
        this.getTagGenerator(writer);
        return this._tagGenerator.nextTag(writer);
    }

    protected void getTagGenerator(BeanProperty writer) {
        if (this._tagGenerator == null) {
            this._tagGenerator = ProtobuffSchemaHelper.hasIndex(writer) ? new AnnotationBasedTagGenerator() : new DefaultTagGenerator();
        }
    }

    protected DataType getDataType(JavaType type) throws JsonMappingException {
        DataType.ScalarType sType = ProtobuffSchemaHelper.getScalarType(type);
        if (sType != null) {
            return sType;
        }
        if (!this._definedTypeElementBuilders.containsBuilderFor(type)) {
            if (Arrays.asList(this._type.getRawClass().getDeclaredClasses()).contains(type.getRawClass())) {
                if (!this._nestedTypes.contains(type)) {
                    this._nestedTypes.add(type);
                    TypeElementBuilder nestedTypeBuilder = ProtobuffSchemaHelper.acceptTypeElement(this._provider, type, this._definedTypeElementBuilders, true);
                    this._builder.addType(nestedTypeBuilder.build());
                }
            } else {
                ProtobuffSchemaHelper.acceptTypeElement(this._provider, type, this._definedTypeElementBuilders, false);
            }
        }
        return DataType.NamedType.create(type.getRawClass().getSimpleName());
    }
}

