/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.EnumElementVisitor;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.MessageElementVisitor;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProtoBufSchemaVisitor
extends JsonFormatVisitorWrapper.Base
implements TypeElementBuilder {
    protected DefinedTypeElementBuilders _definedTypeElementBuilders;
    protected TypeElementBuilder _builder;
    protected boolean _isNested;

    public ProtoBufSchemaVisitor(SerializerProvider provider) {
        this(provider, null, false);
    }

    public ProtoBufSchemaVisitor(SerializerProvider provider, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        super(provider);
        this._definedTypeElementBuilders = definedTypeElementBuilders != null ? definedTypeElementBuilders : new DefinedTypeElementBuilders();
        this._isNested = isNested;
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public Set<TypeElement> buildWithDependencies() {
        LinkedHashSet<TypeElement> allTypeElements = new LinkedHashSet<TypeElement>();
        allTypeElements.add(this.build());
        for (TypeElementBuilder builder : this._definedTypeElementBuilders.getDependencyBuilders()) {
            allTypeElements.add(builder.build());
        }
        return allTypeElements;
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        MessageElementVisitor visitor = new MessageElementVisitor(this._provider, type, this._definedTypeElementBuilders, this._isNested);
        this._builder = visitor;
        return visitor;
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType mapType) {
        return (JsonMapFormatVisitor)this._throwUnsupported("'Map' type not supported as root type by protobuf");
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        return (JsonArrayFormatVisitor)this._throwUnsupported("'Array' type not supported as root type by protobuf");
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        if (!type.isEnumType()) {
            return (JsonStringFormatVisitor)this._throwUnsupported("'String' type not supported as root type by protobuf");
        }
        EnumElementVisitor visitor = new EnumElementVisitor(this._provider, type, this._definedTypeElementBuilders, this._isNested);
        this._builder = visitor;
        return visitor;
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        return (JsonNumberFormatVisitor)this._throwUnsupported("'Number' type not supported as root type by protobuf");
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        return (JsonIntegerFormatVisitor)this._throwUnsupported("'Integer' type not supported as root type by protobuf");
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        return (JsonBooleanFormatVisitor)this._throwUnsupported("'Boolean' type not supported as root type by protobuf");
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        return (JsonNullFormatVisitor)this._throwUnsupported("'Null' type not supported as root type by protobuf");
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        return (JsonAnyFormatVisitor)this._throwUnsupported("'Any' type not supported as root type by protobuf");
    }

    protected <T> T _throwUnsupported() {
        return this._throwUnsupported("Format variation not supported");
    }

    protected <T> T _throwUnsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }
}

