/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.net;

import info.aduna.text.StringUtil;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ParsedURI
implements Cloneable {
    private String _scheme;
    private String _schemeSpecificPart;
    private String _fragment;
    private String _authority;
    private String _path;
    private String _query;

    public ParsedURI(String uriSpec) {
        this._parse(uriSpec);
    }

    public ParsedURI(String scheme, String schemeSpecificPart, String fragment) {
        this._scheme = scheme;
        this._schemeSpecificPart = schemeSpecificPart;
        this._fragment = fragment;
    }

    public ParsedURI(String scheme, String authority, String path, String query, String fragment) {
        this._scheme = scheme;
        this._authority = authority;
        this._path = path;
        this._query = query;
        this._fragment = fragment;
    }

    public boolean isHierarchical() {
        return this._path != null;
    }

    public boolean isOpaque() {
        return this._path == null;
    }

    public boolean isAbsolute() {
        return this._scheme != null;
    }

    public boolean isRelative() {
        return this._scheme == null;
    }

    public boolean isSelfReference() {
        return this._scheme == null && this._authority == null && this._query == null && this._path.length() == 0;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getSchemeSpecificPart() {
        return this._schemeSpecificPart;
    }

    public String getAuthority() {
        return this._authority;
    }

    public String getPath() {
        return this._path;
    }

    public String getQuery() {
        return this._query;
    }

    public String getFragment() {
        return this._fragment;
    }

    public void normalize() {
        if (this._path == null) {
            return;
        }
        this._path = StringUtil.gsub("/./", "/", this._path);
        if (this._path.startsWith("./")) {
            this._path = this._path.substring(2);
        }
        if (this._path.endsWith("/.")) {
            this._path = this._path.substring(0, this._path.length() - 1);
        }
        if (this._path.indexOf("/../") == -1 && !this._path.endsWith("/..")) {
            return;
        }
        LinkedList<String> segments = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(this._path, "/");
        while (st.hasMoreTokens()) {
            segments.add(st.nextToken());
        }
        boolean lastSegmentRemoved = false;
        int i = 1;
        while (i < segments.size()) {
            String segment = (String)segments.get(i);
            if (segment.equals("..")) {
                String prevSegment = (String)segments.get(i - 1);
                if (prevSegment.equals("..")) {
                    i += 2;
                    continue;
                }
                if (i == segments.size() - 1) {
                    lastSegmentRemoved = true;
                }
                segments.remove(i);
                segments.remove(i - 1);
                if (i <= 1) continue;
                --i;
                continue;
            }
            ++i;
        }
        StringBuilder newPath = new StringBuilder(this._path.length());
        if (this._path.startsWith("/")) {
            newPath.append('/');
        }
        int segmentCount = segments.size();
        for (i = 0; i < segmentCount - 1; ++i) {
            newPath.append((String)segments.get(i));
            newPath.append('/');
        }
        if (segmentCount > 0) {
            String lastSegment = (String)segments.get(segmentCount - 1);
            newPath.append(lastSegment);
            if (this._path.endsWith("/") || lastSegmentRemoved) {
                newPath.append('/');
            }
        }
        this._path = newPath.toString();
    }

    public ParsedURI resolve(String relURISpec) {
        ParsedURI relURI = new ParsedURI(relURISpec);
        return this.resolve(relURI);
    }

    public ParsedURI resolve(ParsedURI relURI) {
        String path;
        String authority;
        if (relURI.isAbsolute()) {
            return relURI;
        }
        if (relURI._authority == null && relURI._query == null && relURI._path.length() == 0) {
            ParsedURI result = (ParsedURI)this.clone();
            result._fragment = relURI._fragment;
            return result;
        }
        boolean normalizeURI = false;
        String scheme = this._scheme;
        String query = relURI._query;
        String fragment = relURI._fragment;
        if (relURI._authority != null) {
            authority = relURI._authority;
            path = relURI._path;
        } else {
            authority = this._authority;
            if (relURI._path.startsWith("/")) {
                path = relURI._path;
            } else if (relURI._path.length() == 0) {
                path = this._path;
            } else {
                path = this._path;
                if (path == null) {
                    path = "/";
                } else {
                    if (!path.endsWith("/")) {
                        int lastSlashIdx = path.lastIndexOf(47);
                        path = path.substring(0, lastSlashIdx + 1);
                    }
                    if (path.length() == 0) {
                        path = "/";
                    }
                }
                path = path + relURI._path;
                normalizeURI = true;
            }
        }
        ParsedURI result = new ParsedURI(scheme, authority, path, query, fragment);
        if (normalizeURI) {
            result.normalize();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this._scheme != null) {
            sb.append(this._scheme);
            sb.append(':');
        }
        if (this.isOpaque()) {
            if (this._schemeSpecificPart != null) {
                sb.append(this._schemeSpecificPart);
            }
        } else {
            if (this._authority != null) {
                sb.append("//");
                sb.append(this._authority);
            }
            sb.append(this._path);
            if (this._query != null) {
                sb.append('?');
                sb.append(this._query);
            }
        }
        if (this._fragment != null) {
            sb.append('#');
            sb.append(this._fragment);
        }
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void _parse(String uri) {
        if (this._parseScheme(uri)) {
            if (this._schemeSpecificPart.startsWith("/")) {
                String rest = this._schemeSpecificPart;
                rest = this._parseAuthority(rest);
                rest = this._parsePath(rest);
                rest = this._parseQuery(rest);
                this._parseFragment(rest);
            } else {
                String rest = this._schemeSpecificPart;
                rest = this._parseOpaquePart(rest);
                this._parseFragment(rest);
            }
        } else {
            String rest = uri;
            rest = this._parseAuthority(rest);
            rest = this._parsePath(rest);
            rest = this._parseQuery(rest);
            this._parseFragment(rest);
        }
    }

    private boolean _parseScheme(String uri) {
        int i;
        int c = 0;
        for (i = 0; i < uri.length() && (c = (int)uri.charAt(i)) != 58 && c != 47 && c != 63 && c != 35; ++i) {
        }
        if (c == 58 && i > 0) {
            this._scheme = uri.substring(0, i);
            this._schemeSpecificPart = uri.substring(i + 1);
            return true;
        }
        return false;
    }

    private String _parseAuthority(String s) {
        if (s.startsWith("//")) {
            char c;
            int i;
            for (i = 2; i < s.length() && (c = s.charAt(i)) != '/' && c != '?' && c != '#'; ++i) {
            }
            this._authority = s.substring(2, i);
            return s.substring(i);
        }
        return s;
    }

    private String _parsePath(String s) {
        char c;
        int i;
        for (i = 0; i < s.length() && (c = s.charAt(i)) != '?' && c != '#'; ++i) {
        }
        this._path = s.substring(0, i);
        return s.substring(i);
    }

    private String _parseQuery(String s) {
        if (s.startsWith("?")) {
            char c;
            int i;
            for (i = 1; i < s.length() && (c = s.charAt(i)) != '#'; ++i) {
            }
            this._query = s.substring(1, i);
            return s.substring(i);
        }
        return s;
    }

    private String _parseOpaquePart(String s) {
        char c;
        int i;
        for (i = 0; i < s.length() && (c = s.charAt(i)) != '#'; ++i) {
        }
        this._schemeSpecificPart = s.substring(0, i);
        return s.substring(i);
    }

    private void _parseFragment(String s) {
        if (s.startsWith("#")) {
            this._fragment = s.substring(1);
        }
    }
}

