/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners.scigraph;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;
import org.monarchinitiative.hpotextmining.core.miners.SimpleMinedTerm;
import org.monarchinitiative.hpotextmining.core.miners.TermMiner;
import org.monarchinitiative.hpotextmining.core.miners.TermMinerException;
import org.monarchinitiative.hpotextmining.core.miners.scigraph.SciGraphResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SciGraphTermMiner
implements TermMiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SciGraphTermMiner.class);
    private final ObjectMapper objectMapper;
    private final ConnectionFactory connectionFactory;

    public SciGraphTermMiner(URL server) {
        this(new ConnectionFactory(server));
    }

    SciGraphTermMiner(ConnectionFactory factory) {
        this.connectionFactory = factory;
        this.objectMapper = new ObjectMapper();
    }

    private static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    private static Function<SciGraphResult, MinedTerm> toMinedTerm() {
        return sgr -> new SimpleMinedTerm(sgr.getStart(), sgr.getEnd(), sgr.getToken().getId(), true);
    }

    public Set<MinedTerm> doMining(String query) throws TermMinerException {
        if (query == null) {
            throw new TermMinerException("Query must not be null");
        }
        StringBuilder jsonStringBuilder = new StringBuilder();
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("content", query);
            parameters.put("includeCat", "Phenotype");
            parameters.put("includeAcronym", "true");
            URLConnection connection = this.connectionFactory.getConnection();
            String protocol = connection.getURL().getProtocol();
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(SciGraphTermMiner.getParamsString(parameters));
            }
            var7_12 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    jsonStringBuilder.append(line);
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            if (protocol.equals("http")) {
                ((HttpURLConnection)connection).disconnect();
            } else if (protocol.equals("https")) {
                ((HttpsURLConnection)connection).disconnect();
            }
        }
        catch (ProtocolException e) {
            LOGGER.warn("Protocol exception", (Throwable)e);
            throw new TermMinerException("Protocol exception", e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Unsupported encoding", (Throwable)e);
            throw new TermMinerException("Unsupported encoding", e);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to connect to host '{}'", (Object)e.getMessage(), (Object)e);
            throw new TermMinerException("Unable to connect to host " + e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.warn("I/O error occured", (Throwable)e);
            throw new TermMinerException("I/O error occured", e);
        }
        try {
            SciGraphResult[] sciGraphResults = (SciGraphResult[])this.objectMapper.readValue(jsonStringBuilder.toString(), SciGraphResult[].class);
            return Arrays.stream(sciGraphResults).map(SciGraphTermMiner.toMinedTerm()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new TermMinerException("Error occurred during parsing response from the server", e);
        }
    }

    public static class ConnectionFactory {
        private final URL url;

        public ConnectionFactory(URL url) {
            this.url = url;
        }

        URLConnection getConnection() throws IOException {
            String protocol;
            URLConnection connection = this.url.openConnection();
            switch (protocol = this.url.getProtocol()) {
                case "http": {
                    ((HttpURLConnection)connection).setRequestMethod("POST");
                    break;
                }
                case "https": {
                    ((HttpsURLConnection)connection).setRequestMethod("POST");
                    break;
                }
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return connection;
        }
    }
}

