/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFDatasetUtils;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.core.UniqueNamer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TurtleRDFParser
implements RDFParser {
    public static final Pattern IRIREF_MINUS_CONTAINER = Pattern.compile("(?:(?:[^\\x00-\\x20<>\"{}|\\^`\\\\]|" + com.github.jsonldjava.core.Regex.UCHAR + ")*)|" + Regex.PREFIXED_NAME);
    private static final Pattern PN_LOCAL_ESC_MATCHED = Pattern.compile("[\\\\]([_~\\.\\-!$&'\\(\\)*+,;=/?#@%])");

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RDFDataset parse(Object input) throws JsonLdError {
        if (!(input instanceof String)) {
            throw new JsonLdError(JsonLdError.Error.INVALID_INPUT, "Invalid input; Triple RDF Parser requires a string input");
        }
        RDFDataset result = new RDFDataset();
        State state = new State((String)input);
        while (true) {
            String bnode;
            block61: {
                Matcher match;
                block63: {
                    String datatype;
                    String lang;
                    String value;
                    block67: {
                        block64: {
                            block65: {
                                block66: {
                                    block62: {
                                        String name;
                                        if ("".equals(state.line)) {
                                            return result;
                                        }
                                        match = Regex.DIRECTIVE.matcher(state.line);
                                        if (match.find()) {
                                            if (match.group(1) != null || match.group(4) != null) {
                                                String iri;
                                                String ns = match.group(1) != null ? match.group(1) : match.group(4);
                                                String string = iri = match.group(1) != null ? match.group(2) : match.group(5);
                                                if (!iri.contains(":")) {
                                                    iri = state.baseIri + iri;
                                                }
                                                iri = RDFDatasetUtils.unescape(iri);
                                                this.validateIRI(state, iri);
                                                state.namespaces.put(ns, iri);
                                                result.setNamespace(ns, iri);
                                            } else {
                                                String base = match.group(3) != null ? match.group(3) : match.group(6);
                                                base = RDFDatasetUtils.unescape(base);
                                                this.validateIRI(state, base);
                                                state.baseIri = !base.contains(":") ? state.baseIri + base : base;
                                            }
                                            state.advanceLinePosition(match.group(0).length());
                                            continue;
                                        }
                                        if (state.curSubject == null) {
                                            match = Regex.SUBJECT.matcher(state.line);
                                            if (match.find()) {
                                                String iri;
                                                if (match.group(1) != null) {
                                                    iri = RDFDatasetUtils.unescape(match.group(1));
                                                    if (!iri.contains(":")) {
                                                        iri = state.baseIri + iri;
                                                    }
                                                } else if (match.group(2) != null) {
                                                    String ns = match.group(2);
                                                    name = TurtleRDFParser.unescapeReserved(match.group(3));
                                                    iri = state.expandIRI(ns, name);
                                                } else {
                                                    iri = match.group(4) != null ? state.expandIRI(match.group(4), "") : (match.group(5) != null ? state.namer.getName(match.group(0).trim()) : state.namer.getName());
                                                }
                                                this.validateIRI(state, iri);
                                                state.curSubject = iri;
                                                state.advanceLinePosition(match.group(0).length());
                                            } else if (state.line.startsWith("[")) {
                                                String bnode2 = state.namer.getName();
                                                state.advanceLinePosition(1);
                                                state.push();
                                                state.curSubject = bnode2;
                                            } else {
                                                String bnode3;
                                                if (!state.line.startsWith("(")) {
                                                    throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; missing expected subject. {line: " + state.lineNumber + "position: " + state.linePosition + "}");
                                                }
                                                state.curSubject = bnode3 = state.namer.getName();
                                                state.advanceLinePosition(1);
                                                state.push();
                                                state.curSubject = bnode3;
                                                state.curPredicate = "http://www.w3.org/1999/02/22-rdf-syntax-ns#first";
                                            }
                                        }
                                        if (state.curPredicate == null) {
                                            match = Regex.PREDICATE.matcher(state.line);
                                            if (!match.find()) {
                                                throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; missing expected predicate. {line: " + state.lineNumber + "position: " + state.linePosition + "}");
                                            }
                                            String iri = "";
                                            if (match.group(1) != null) {
                                                iri = RDFDatasetUtils.unescape(match.group(1));
                                                if (!iri.contains(":")) {
                                                    iri = state.baseIri + iri;
                                                }
                                            } else if (match.group(2) != null) {
                                                String ns = match.group(2);
                                                name = TurtleRDFParser.unescapeReserved(match.group(3));
                                                iri = state.expandIRI(ns, name);
                                            } else {
                                                iri = match.group(4) != null ? state.expandIRI(match.group(4), "") : "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
                                            }
                                            this.validateIRI(state, iri);
                                            state.curPredicate = iri;
                                            state.advanceLinePosition(match.group(0).length());
                                        }
                                        if (state.line.startsWith("[")) {
                                            String bnode4 = state.namer.getName();
                                            result.addTriple(state.curSubject, state.curPredicate, bnode4);
                                            state.advanceLinePosition(1);
                                            if (state.line.startsWith("]")) {
                                                state.advanceLinePosition(1);
                                                break block61;
                                            } else {
                                                state.push();
                                                state.curSubject = bnode4;
                                                continue;
                                            }
                                        }
                                        if (state.line.startsWith("(")) {
                                            state.advanceLinePosition(1);
                                            if (state.line.startsWith(")")) {
                                                state.advanceLinePosition(1);
                                                result.addTriple(state.curSubject, state.curPredicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                                                break block61;
                                            } else {
                                                String bnode5 = state.namer.getName();
                                                result.addTriple(state.curSubject, state.curPredicate, bnode5);
                                                state.push();
                                                state.curSubject = bnode5;
                                                state.curPredicate = "http://www.w3.org/1999/02/22-rdf-syntax-ns#first";
                                                continue;
                                            }
                                        }
                                        match = Regex.OBJECT.matcher(state.line);
                                        if (!match.find()) {
                                            throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; missing expected object or blank node. {line: " + state.lineNumber + "position: " + state.linePosition + "}");
                                        }
                                        String iri = null;
                                        if (match.group(1) != null) {
                                            iri = RDFDatasetUtils.unescape(match.group(1));
                                            if (!iri.contains(":")) {
                                                iri = state.baseIri + iri;
                                            }
                                        } else if (match.group(2) != null) {
                                            String ns = match.group(2);
                                            name = TurtleRDFParser.unescapeReserved(match.group(3));
                                            iri = state.expandIRI(ns, name);
                                        } else if (match.group(4) != null) {
                                            iri = state.expandIRI(match.group(4), "");
                                        } else if (match.group(5) != null) {
                                            iri = state.namer.getName(match.group(0).trim());
                                        }
                                        if (iri == null) break block62;
                                        this.validateIRI(state, iri);
                                        result.addTriple(state.curSubject, state.curPredicate, iri);
                                        break block63;
                                    }
                                    value = match.group(6);
                                    lang = null;
                                    datatype = null;
                                    if (value == null) break block64;
                                    value = this.unquoteString(value);
                                    value = RDFDatasetUtils.unescape(value);
                                    lang = match.group(7);
                                    if (lang != null) break block65;
                                    if (match.group(8) == null) break block66;
                                    datatype = RDFDatasetUtils.unescape(match.group(8));
                                    if (!datatype.contains(":")) {
                                        datatype = state.baseIri + datatype;
                                    }
                                    this.validateIRI(state, datatype);
                                    break block67;
                                }
                                if (match.group(9) != null) {
                                    datatype = state.expandIRI(match.group(9), TurtleRDFParser.unescapeReserved(match.group(10)));
                                    break block67;
                                } else if (match.group(11) != null) {
                                    datatype = state.expandIRI(match.group(11), "");
                                }
                                break block67;
                            }
                            datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
                            break block67;
                        }
                        if (match.group(12) != null) {
                            value = match.group(12);
                            datatype = "http://www.w3.org/2001/XMLSchema#double";
                        } else if (match.group(13) != null) {
                            value = match.group(13);
                            datatype = "http://www.w3.org/2001/XMLSchema#decimal";
                        } else if (match.group(14) != null) {
                            value = match.group(14);
                            datatype = "http://www.w3.org/2001/XMLSchema#integer";
                        } else if (match.group(15) != null) {
                            value = match.group(15);
                            datatype = "http://www.w3.org/2001/XMLSchema#boolean";
                        }
                    }
                    result.addTriple(state.curSubject, state.curPredicate, value, datatype, lang);
                }
                state.advanceLinePosition(match.group(0).length());
            }
            boolean collectionClosed = false;
            while (state.line.startsWith(")")) {
                if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#first".equals(state.curPredicate)) {
                    throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; unexpected ). {line: " + state.lineNumber + "position: " + state.linePosition + "}");
                }
                result.addTriple(state.curSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                state.pop();
                state.advanceLinePosition(1);
                collectionClosed = true;
            }
            boolean expectDotOrPred = false;
            if (state.line.startsWith("]")) {
                bnode = state.curSubject;
                state.pop();
                state.advanceLinePosition(1);
                if (state.curSubject == null) {
                    state.curSubject = bnode;
                    expectDotOrPred = true;
                }
            }
            if (!expectDotOrPred && state.line.startsWith(",")) {
                state.advanceLinePosition(1);
                continue;
            }
            if (!expectDotOrPred) {
                while (state.line.startsWith(";")) {
                    state.curPredicate = null;
                    state.advanceLinePosition(1);
                    expectDotOrPred = true;
                }
            }
            if (state.line.startsWith(".")) {
                if (state.expectingBnodeClose) {
                    throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; missing expected )\"]\". {line: " + state.lineNumber + "position: " + state.linePosition + "}");
                }
                state.curSubject = null;
                state.curPredicate = null;
                state.advanceLinePosition(1);
                continue;
            }
            if (expectDotOrPred) continue;
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#first".equals(state.curPredicate)) {
                bnode = state.namer.getName();
                result.addTriple(state.curSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", bnode);
                state.curSubject = bnode;
                continue;
            }
            if (!collectionClosed) break;
        }
        throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; missing expected \"]\" \",\" \";\" or \".\". {line: " + state.lineNumber + "position: " + state.linePosition + "}");
    }

    private void validateIRI(State state, String iri) throws JsonLdError {
        if (!IRIREF_MINUS_CONTAINER.matcher(iri).matches()) {
            throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; invalid IRI after escaping. {line: " + state.lineNumber + "position: " + state.linePosition + "}");
        }
    }

    static String unescapeReserved(String str) {
        Matcher m;
        if (str != null && (m = PN_LOCAL_ESC_MATCHED.matcher(str)).find()) {
            return m.replaceAll("$1");
        }
        return str;
    }

    private String unquoteString(String value) {
        if (value.startsWith("\"\"\"") || value.startsWith("'''")) {
            return value.substring(3, value.length() - 3);
        }
        if (value.startsWith("\"") || value.startsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private class State {
        String baseIri = "";
        Map<String, String> namespaces = new LinkedHashMap<String, String>();
        String curSubject = null;
        String curPredicate = null;
        String line = null;
        int lineNumber = 0;
        int linePosition = 0;
        UniqueNamer namer = new UniqueNamer("_:b");
        private final Stack<Map<String, String>> stack = new Stack();
        public boolean expectingBnodeClose = false;

        public State(String input) throws JsonLdError {
            this.line = input;
            this.lineNumber = 1;
            this.advanceLinePosition(0);
        }

        public void push() {
            this.stack.push((Map<String, String>)new LinkedHashMap<String, String>(){
                {
                    this.put(State.this.curSubject, State.this.curPredicate);
                }
            });
            this.expectingBnodeClose = true;
            this.curSubject = null;
            this.curPredicate = null;
        }

        public void pop() {
            if (this.stack.size() > 0) {
                for (Map.Entry<String, String> x : this.stack.pop().entrySet()) {
                    this.curSubject = x.getKey();
                    this.curPredicate = x.getValue();
                }
            }
            if (this.stack.size() == 0) {
                this.expectingBnodeClose = false;
            }
        }

        private void advanceLineNumber() throws JsonLdError {
            Matcher match = Regex.NEXT_EOLN.matcher(this.line);
            if (match.find()) {
                String[] split = match.group(0).split("" + Regex.EOLN);
                this.lineNumber += split.length - 1;
                this.linePosition += split[split.length - 1].length();
                this.line = this.line.substring(match.group(0).length());
            }
        }

        public void advanceLinePosition(int len) throws JsonLdError {
            Matcher match;
            if (len > 0) {
                this.linePosition += len;
                this.line = this.line.substring(len);
            }
            while (!"".equals(this.line) && (match = Regex.COMMENT_OR_WS.matcher(this.line)).find() && match.group(0).length() > 0) {
                Matcher eoln = Regex.EOLN.matcher(match.group(0));
                int end = 0;
                while (eoln.find()) {
                    ++this.lineNumber;
                    end = eoln.end();
                }
                this.linePosition = match.group(0).length() - end;
                this.line = this.line.substring(match.group(0).length());
            }
            if ("".equals(this.line) && !this.endIsOK()) {
                throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "Error while parsing Turtle; unexpected end of input. {line: " + this.lineNumber + ", position:" + this.linePosition + "}");
            }
        }

        private boolean endIsOK() {
            return this.curSubject == null && this.stack.size() == 0;
        }

        public String expandIRI(String ns, String name) throws JsonLdError {
            if (this.namespaces.containsKey(ns)) {
                return this.namespaces.get(ns) + name;
            }
            throw new JsonLdError(JsonLdError.Error.PARSE_ERROR, "No prefix found for: " + ns + " {line: " + this.lineNumber + ", position:" + this.linePosition + "}");
        }
    }

    static class Regex {
        public static final Pattern PREFIX_ID = Pattern.compile("@prefix" + com.github.jsonldjava.core.Regex.WS_1_N + com.github.jsonldjava.core.Regex.PNAME_NS + com.github.jsonldjava.core.Regex.WS_1_N + com.github.jsonldjava.core.Regex.IRIREF + com.github.jsonldjava.core.Regex.WS_0_N + "\\." + com.github.jsonldjava.core.Regex.WS_0_N);
        public static final Pattern BASE = Pattern.compile("@base" + com.github.jsonldjava.core.Regex.WS_1_N + com.github.jsonldjava.core.Regex.IRIREF + com.github.jsonldjava.core.Regex.WS_0_N + "\\." + com.github.jsonldjava.core.Regex.WS_0_N);
        public static final Pattern SPARQL_PREFIX = Pattern.compile("[Pp][Rr][Ee][Ff][Ii][Xx]" + com.github.jsonldjava.core.Regex.WS + com.github.jsonldjava.core.Regex.PNAME_NS + com.github.jsonldjava.core.Regex.WS + com.github.jsonldjava.core.Regex.IRIREF + com.github.jsonldjava.core.Regex.WS_0_N);
        public static final Pattern SPARQL_BASE = Pattern.compile("[Bb][Aa][Ss][Ee]" + com.github.jsonldjava.core.Regex.WS + com.github.jsonldjava.core.Regex.IRIREF + com.github.jsonldjava.core.Regex.WS_0_N);
        public static final Pattern PREFIXED_NAME = Pattern.compile("(?:" + com.github.jsonldjava.core.Regex.PNAME_LN + "|" + com.github.jsonldjava.core.Regex.PNAME_NS + ")");
        public static final Pattern IRI = Pattern.compile("(?:" + com.github.jsonldjava.core.Regex.IRIREF + "|" + PREFIXED_NAME + ")");
        public static final Pattern ANON = Pattern.compile("(?:\\[" + com.github.jsonldjava.core.Regex.WS + "*\\])");
        public static final Pattern BLANK_NODE = Pattern.compile(com.github.jsonldjava.core.Regex.BLANK_NODE_LABEL + "|" + ANON);
        public static final Pattern STRING = Pattern.compile("(" + com.github.jsonldjava.core.Regex.STRING_LITERAL_LONG_SINGLE_QUOTE + "|" + com.github.jsonldjava.core.Regex.STRING_LITERAL_LONG_QUOTE + "|" + com.github.jsonldjava.core.Regex.STRING_LITERAL_QUOTE + "|" + com.github.jsonldjava.core.Regex.STRING_LITERAL_SINGLE_QUOTE + ")");
        public static final Pattern BOOLEAN_LITERAL = Pattern.compile("(true|false)");
        public static final Pattern RDF_LITERAL = Pattern.compile(STRING + "(?:" + com.github.jsonldjava.core.Regex.LANGTAG + "|\\^\\^" + IRI + ")?");
        public static final Pattern NUMERIC_LITERAL = Pattern.compile("(" + com.github.jsonldjava.core.Regex.DOUBLE + ")|(" + com.github.jsonldjava.core.Regex.DECIMAL + ")|(" + com.github.jsonldjava.core.Regex.INTEGER + ")");
        public static final Pattern LITERAL = Pattern.compile(RDF_LITERAL + "|" + NUMERIC_LITERAL + "|" + BOOLEAN_LITERAL);
        public static final Pattern DIRECTIVE = Pattern.compile("^(?:" + PREFIX_ID + "|" + BASE + "|" + SPARQL_PREFIX + "|" + SPARQL_BASE + ")");
        public static final Pattern SUBJECT = Pattern.compile("^" + IRI + "|" + BLANK_NODE);
        public static final Pattern PREDICATE = Pattern.compile("^" + IRI + "|a" + com.github.jsonldjava.core.Regex.WS_1_N);
        public static final Pattern OBJECT = Pattern.compile("^" + IRI + "|" + BLANK_NODE + "|" + LITERAL);
        public static final Pattern EOLN = Pattern.compile("(?:\r\n)|(?:\n)|(?:\r)");
        public static final Pattern NEXT_EOLN = Pattern.compile("^.*(?:" + EOLN + ")" + com.github.jsonldjava.core.Regex.WS_0_N);
        public static final Pattern COMMENT_OR_WS = Pattern.compile("^(?:(?:[#].*(?:" + EOLN + ")" + com.github.jsonldjava.core.Regex.WS_0_N + ")|(?:" + com.github.jsonldjava.core.Regex.WS_1_N + "))");

        Regex() {
        }
    }
}

