/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import org.controlsfx.control.InfoOverlay;

public class InfoOverlaySkin
extends BehaviorSkinBase<InfoOverlay, BehaviorBase<InfoOverlay>> {
    private final ImageView EXPAND_IMAGE = new ImageView(new Image(InfoOverlay.class.getResource("expand.png").toExternalForm()));
    private final ImageView COLLAPSE_IMAGE = new ImageView(new Image(InfoOverlay.class.getResource("collapse.png").toExternalForm()));
    private static final Duration TRANSITION_DURATION = new Duration(350.0);
    private Node content;
    private Label infoLabel;
    private HBox infoPanel;
    private ToggleButton expandCollapseButton;
    private Timeline timeline;
    private DoubleProperty transition = new SimpleDoubleProperty((Object)this, "transition", 0.0){

        protected void invalidated() {
            ((InfoOverlay)InfoOverlaySkin.this.getSkinnable()).requestLayout();
        }
    };

    public InfoOverlaySkin(final InfoOverlay control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.content = control.getContent();
        control.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> o, Boolean wasHover, Boolean isHover) {
                if (control.isShowOnHover() && (isHover.booleanValue() && !InfoOverlaySkin.this.isExpanded() || !isHover.booleanValue() && InfoOverlaySkin.this.isExpanded())) {
                    InfoOverlaySkin.this.doToggle();
                }
            }
        });
        this.infoLabel = new Label();
        this.infoLabel.setWrapText(true);
        this.infoLabel.setAlignment(Pos.TOP_LEFT);
        this.infoLabel.getStyleClass().add((Object)"info");
        this.infoLabel.textProperty().bind((ObservableValue)control.textProperty());
        this.expandCollapseButton = new ToggleButton();
        this.expandCollapseButton.setMouseTransparent(true);
        this.expandCollapseButton.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)control.showOnHoverProperty()));
        this.expandCollapseButton.managedProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)control.showOnHoverProperty()));
        this.updateToggleButton();
        this.infoPanel = new HBox(new Node[]{this.infoLabel, this.expandCollapseButton});
        this.infoPanel.setAlignment(Pos.TOP_LEFT);
        this.infoPanel.setFillHeight(true);
        this.infoPanel.getStyleClass().add((Object)"info-panel");
        this.infoPanel.setCursor(Cursor.HAND);
        this.infoPanel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (!control.isShowOnHover()) {
                    InfoOverlaySkin.this.doToggle();
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.content, this.infoPanel});
        this.registerChangeListener((ObservableValue)control.contentProperty(), "CONTENT");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("CONTENT".equals(p)) {
            this.getChildren().remove(0);
            this.getChildren().add(0, (Object)((InfoOverlay)this.getSkinnable()).getContent());
            ((InfoOverlay)this.getSkinnable()).requestLayout();
        }
    }

    private void doToggle() {
        this.expandCollapseButton.setSelected(!this.expandCollapseButton.isSelected());
        this.toggleInfoPanel();
        this.updateToggleButton();
    }

    private boolean isExpanded() {
        return this.expandCollapseButton.isSelected();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double contentPrefHeight = this.content.prefHeight(contentWidth);
        double toggleButtonPrefWidth = this.expandCollapseButton.prefWidth(-1.0);
        this.expandCollapseButton.setMinWidth(toggleButtonPrefWidth);
        Insets infoPanelPadding = this.infoPanel.getPadding();
        double infoLabelWidth = this.snapSize(contentWidth - toggleButtonPrefWidth - infoPanelPadding.getLeft() - infoPanelPadding.getRight());
        double prefInfoPanelHeight = (this.snapSize(this.infoLabel.prefHeight(infoLabelWidth)) + this.snapSpace(this.infoPanel.getPadding().getTop()) + this.snapSpace(this.infoPanel.getPadding().getBottom())) * this.transition.get();
        this.infoLabel.setMaxWidth(infoLabelWidth);
        this.infoLabel.setMaxHeight(prefInfoPanelHeight);
        this.layoutInArea(this.content, contentX, contentY, contentWidth, contentHeight, -1.0, HPos.CENTER, VPos.TOP);
        this.layoutInArea((Node)this.infoPanel, contentX, this.snapPosition(contentPrefHeight - prefInfoPanelHeight), contentWidth, prefInfoPanelHeight, 0.0, HPos.CENTER, VPos.BOTTOM);
    }

    private void updateToggleButton() {
        if (this.expandCollapseButton.isSelected()) {
            this.expandCollapseButton.getStyleClass().setAll((Object[])new String[]{"collapse-button"});
            this.expandCollapseButton.setGraphic((Node)this.COLLAPSE_IMAGE);
        } else {
            this.expandCollapseButton.getStyleClass().setAll((Object[])new String[]{"expand-button"});
            this.expandCollapseButton.setGraphic((Node)this.EXPAND_IMAGE);
        }
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double insets = topInset + bottomInset;
        return insets + (this.content == null ? 0.0 : this.content.prefHeight(width));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double insets = leftInset + rightInset;
        return insets + (this.content == null ? 0.0 : this.content.prefWidth(height));
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    private void toggleInfoPanel() {
        KeyFrame k2;
        KeyFrame k1;
        Duration duration;
        if (this.content == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isExpanded()) {
            k1 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0)});
            k2 = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.LINEAR)});
        } else {
            k1 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1)});
            k2 = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.LINEAR)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{k1, k2});
        this.timeline.play();
    }
}

