/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.demo;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.monarchinitiative.hpotextmining.demo.Controller;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Play
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Play.class);
    private static final String SCIGRAPH_URL_STRING = "https://scigraph-ontology.monarchinitiative.org/scigraph/annotations/complete";
    private static final String HPO_OBO_PATH = "/HP.obo";
    private final URL scigraphUrl;
    private final Ontology ontology = OntologyLoader.loadOntology((InputStream)Play.class.getResourceAsStream("/HP.obo"));
    private final ExecutorService executorService;

    public Play() throws Exception {
        this.scigraphUrl = new URL(SCIGRAPH_URL_STRING);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public static void main(String[] args) {
        Play.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Controller controller = new Controller(stage, this.scigraphUrl, this.executorService, this.ontology);
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("Controller.fxml"));
        loader.setControllerFactory(clz -> controller);
        stage.setScene(new Scene((Parent)loader.load()));
        stage.show();
    }

    public void stop() throws Exception {
        super.stop();
        this.executorService.shutdown();
    }
}

