/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;

public class ResourceUtils {
    public static String readResource(String path) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)ResourceUtils.class.getResourceAsStream(path), (Writer)writer, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Problem reading resource " + path, (Throwable)e);
        }
        return writer.toString();
    }

    public static void copyResourceToFile(String path, File outFile) {
        try (InputStream input = ResourceUtils.class.getResourceAsStream(path);
             FileOutputStream os = new FileOutputStream(outFile);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Problem with copying resource to file", (Throwable)e);
        }
    }
}

