/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.hpo;

import java.util.List;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.formats.Gene;
import org.monarchinitiative.phenol.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class DiseaseToGeneAssociation {
    private final TermId disease;
    private final List<GeneToAssociation> gene2assoc;

    public DiseaseToGeneAssociation(TermId id, List<GeneToAssociation> genes) {
        this.gene2assoc = genes;
        this.disease = id;
    }

    public TermId getDiseaseId() {
        return this.disease;
    }

    public List<Gene> getGeneList() {
        return this.gene2assoc.stream().map(GeneToAssociation::getGene).collect(Collectors.toList());
    }

    public List<GeneToAssociation> getAssociations() {
        return this.gene2assoc;
    }

    public String toString() {
        return String.format("%s: %s", this.disease.getValue(), this.gene2assoc.stream().map(GeneToAssociation::getGene).map(Gene::toString).collect(Collectors.joining(";")));
    }
}

