/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.hpo;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class HpoDisease {
    private final String name;
    private final TermId diseaseDatabaseId;
    private final List<HpoAnnotation> phenotypicAbnormalities;
    private final List<TermId> modesOfInheritance;
    private final List<TermId> negativeAnnotations;

    public TermId getDiseaseDatabaseId() {
        return this.diseaseDatabaseId;
    }

    public HpoDisease(String name, TermId databaseId, List<HpoAnnotation> phenotypicAbnormalities, List<TermId> modesOfInheritance, List<TermId> notTerms) {
        this.name = name;
        this.diseaseDatabaseId = databaseId;
        this.phenotypicAbnormalities = ImmutableList.copyOf(phenotypicAbnormalities);
        this.modesOfInheritance = ImmutableList.copyOf(modesOfInheritance);
        this.negativeAnnotations = ImmutableList.copyOf(notTerms);
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfPhenotypeAnnotations() {
        return this.phenotypicAbnormalities.size();
    }

    public List<HpoAnnotation> getPhenotypicAbnormalities() {
        return this.phenotypicAbnormalities;
    }

    public List<TermId> getPhenotypicAbnormalityTermIdList() {
        return this.phenotypicAbnormalities.stream().map(HpoAnnotation::getTermId).collect(Collectors.toList());
    }

    public List<TermId> getModesOfInheritance() {
        return this.modesOfInheritance;
    }

    public List<TermId> getNegativeAnnotations() {
        return this.negativeAnnotations;
    }

    public HpoAnnotation getAnnotation(TermId id) {
        return this.phenotypicAbnormalities.stream().filter(timd -> timd.getTermId().equals(id)).findAny().orElse(null);
    }

    public boolean isDirectlyAnnotatedTo(TermId tid) {
        for (HpoAnnotation tiwm : this.phenotypicAbnormalities) {
            if (!tiwm.getTermId().equals(tid)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectlyAnnotatedToAnyOf(Set<TermId> tidset) {
        for (HpoAnnotation tiwm : this.phenotypicAbnormalities) {
            if (!tidset.contains(tiwm.getTermId())) continue;
            return true;
        }
        return false;
    }

    public double getFrequencyOfTermInDisease(TermId tid) {
        HpoAnnotation tiwm = this.phenotypicAbnormalities.stream().filter(twm -> twm.getTermId().equals(tid)).findFirst().orElse(null);
        if (tiwm == null) {
            return 0.0;
        }
        return tiwm.getFrequency();
    }

    public String toString() {
        String abnormalityList = this.phenotypicAbnormalities.stream().map(HpoAnnotation::getIdWithPrefix).collect(Collectors.joining(";"));
        return String.format("HpoDisease [name=%s;%s] phenotypicAbnormalities=\n%s, modesOfInheritance=%s", this.name, this.diseaseDatabaseId.getValue(), abnormalityList, this.modesOfInheritance);
    }

    public String getDatabase() {
        return this.diseaseDatabaseId.getPrefix();
    }
}

