/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.mpo;

import java.util.List;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

abstract class MpModel {
    protected TermId markerId;
    protected List<MpAnnotation> phenotypicAbnormalities;

    MpModel() {
    }

    public TermId getMarkerId() {
        return this.markerId;
    }

    public List<MpAnnotation> getPhenotypicAbnormalities() {
        return this.phenotypicAbnormalities;
    }

    public boolean hasMaleSpecificAnnotation() {
        return this.phenotypicAbnormalities.stream().anyMatch(MpAnnotation::maleSpecificAbnormal);
    }

    public List<TermId> getMaleSpecificMpTermIds() {
        return this.phenotypicAbnormalities.stream().filter(MpAnnotation::maleSpecificAbnormal).map(MpAnnotation::getTermId).collect(Collectors.toList());
    }

    public boolean hasFemaleSpecificAnnotation() {
        return this.phenotypicAbnormalities.stream().anyMatch(MpAnnotation::femaleSpecificAbnormal);
    }

    public List<TermId> getFemaleSpecificMpTermIds() {
        return this.phenotypicAbnormalities.stream().filter(MpAnnotation::femaleSpecificAbnormal).map(MpAnnotation::getTermId).collect(Collectors.toList());
    }

    public boolean hasSexSpecificAnnotation() {
        return this.phenotypicAbnormalities.stream().anyMatch(MpAnnotation::sexSpecific);
    }

    public List<TermId> getSexSpecificMpTermIds() {
        return this.phenotypicAbnormalities.stream().filter(MpAnnotation::sexSpecific).map(MpAnnotation::getTermId).collect(Collectors.toList());
    }

    public int getTotalAnnotationCount() {
        return this.phenotypicAbnormalities.size();
    }
}

