/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.mpo;

import java.util.List;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.formats.mpo.MpAllelicComposition;
import org.monarchinitiative.phenol.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.formats.mpo.MpModel;
import org.monarchinitiative.phenol.formats.mpo.MpStrain;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpSimpleModel
extends MpModel {
    private final MpAllelicComposition allelicComposition;
    private final MpStrain strain;
    private final TermId genotypeId;
    private final TermId alleleId;
    private final String alleleSymbol;

    public MpSimpleModel(TermId genoId, MpStrain background, MpAllelicComposition allelicComp, TermId alleleId, String alleleSymbol, TermId markerId, List<MpAnnotation> annots) {
        this.genotypeId = genoId;
        this.strain = background;
        this.allelicComposition = allelicComp;
        this.phenotypicAbnormalities = annots;
        this.alleleId = alleleId;
        this.alleleSymbol = alleleSymbol;
        this.markerId = markerId;
    }

    public MpAllelicComposition getAllelicComposition() {
        return this.allelicComposition;
    }

    public MpStrain getStrain() {
        return this.strain;
    }

    public TermId getGenotypeId() {
        return this.genotypeId;
    }

    public TermId getAlleleId() {
        return this.alleleId;
    }

    public String getAlleleSymbol() {
        return this.alleleSymbol;
    }

    public String toString() {
        String abn = this.phenotypicAbnormalities.stream().map(MpAnnotation::toString).collect(Collectors.joining("\n"));
        return String.format("[MpSimpleModel: %s] %s %s(%s): %s / %s \n%s", this.genotypeId.getValue(), this.markerId.getValue(), this.alleleSymbol, this.alleleId.getValue(), this.allelicComposition, this.strain, abn);
    }
}

