/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.uberpheno;

import com.google.common.collect.ComparisonChain;
import java.util.Optional;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class UberphenoGeneAnnotation
implements TermAnnotation {
    private static final long serialVersionUID = 1L;
    private final int entrezGeneId;
    private final String entrezGeneSymbol;
    private final String termDescription;
    private final TermId termId;
    private final String evidenceDescription;

    public UberphenoGeneAnnotation(int entrezGeneId, String entrezGeneSymbol, String termDescription, TermId uberphenoTermId, String evidenceDescription) {
        this.entrezGeneId = entrezGeneId;
        this.entrezGeneSymbol = entrezGeneSymbol;
        this.termDescription = termDescription;
        this.termId = uberphenoTermId;
        this.evidenceDescription = evidenceDescription;
    }

    public int getEntrezGeneId() {
        return this.entrezGeneId;
    }

    public String getGeneSymbol() {
        return this.entrezGeneSymbol;
    }

    public String getTermDescription() {
        return this.termDescription;
    }

    @Override
    public TermId getTermId() {
        return this.termId;
    }

    @Override
    public TermId getLabel() {
        return TermId.of(String.format("NCBIGene:%d", this.entrezGeneId));
    }

    public String getEvidenceDescription() {
        return this.evidenceDescription;
    }

    @Override
    public Optional<String> getEvidenceCode() {
        return Optional.ofNullable(this.evidenceDescription);
    }

    public String toString() {
        return "UberphenoGeneAnnotation [entrezGeneId=" + this.entrezGeneId + ", entrezGeneSymbol=" + this.entrezGeneSymbol + ", termDescription=" + this.termDescription + ", uberphenoTermId=" + this.termId + ", evidenceDescription=" + this.evidenceDescription + "]";
    }

    @Override
    public int compareTo(TermAnnotation o) {
        if (!(o instanceof UberphenoGeneAnnotation)) {
            throw new PhenolRuntimeException("Cannot compare " + o + " to a UberphenoGeneAnnotation");
        }
        UberphenoGeneAnnotation that = (UberphenoGeneAnnotation)o;
        return ComparisonChain.start().compare(this.entrezGeneId, that.entrezGeneId).compare((Comparable)this.termId, (Comparable)that.termId).result();
    }
}

