/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.graph.util;

import java.util.Collection;
import java.util.Iterator;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;

public class GraphUtil<V> {
    public static <V> void addEdgeToGraph(DefaultDirectedGraph<V, IdLabeledEdge> g, V t1, V t2, int id) {
        g.addVertex(t1);
        g.addVertex(t2);
        IdLabeledEdge e = new IdLabeledEdge(id);
        g.addEdge(t1, t2, (Object)e);
    }

    public static <V> Iterator<V> viaInEdgeIterator(DefaultDirectedGraph<V, ? extends IdLabeledEdge> g, V v) {
        final Iterator iter = g.incomingEdgesOf(v).iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public V next() {
                return ((IdLabeledEdge)((Object)iter.next())).getSource();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <V> Iterator<V> viaOutEdgeIterator(DefaultDirectedGraph<V, ? extends IdLabeledEdge> g, V v) {
        final Iterator iter = g.outgoingEdgesOf(v).iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public V next() {
                return ((IdLabeledEdge)((Object)iter.next())).getTarget();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <V> DefaultDirectedGraph<V, IdLabeledEdge> subGraph(DefaultDirectedGraph<V, IdLabeledEdge> g, Collection<V> vertices) {
        DefaultDirectedGraph newSubgraph = new DefaultDirectedGraph(IdLabeledEdge.class);
        for (IdLabeledEdge e : g.edgeSet()) {
            if (!vertices.contains(e.getSource()) || !vertices.contains(e.getTarget())) continue;
            IdLabeledEdge termIdEdge = new IdLabeledEdge(e.getId());
            newSubgraph.addVertex(e.getSource());
            newSubgraph.addVertex(e.getTarget());
            newSubgraph.addEdge(e.getSource(), e.getTarget(), (Object)termIdEdge);
        }
        return newSubgraph;
    }
}

