/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.algo;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.BreadthFirstSearch;
import org.monarchinitiative.phenol.ontology.data.ImmutableOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Relationship;
import org.monarchinitiative.phenol.ontology.data.RelationshipType;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(OntologyAlgorithm.class);

    private OntologyAlgorithm() {
    }

    public static boolean existsPath(Ontology ontology, TermId sourceID, TermId destID) {
        if (sourceID.equals(destID)) {
            return false;
        }
        DefaultDirectedGraph<TermId, IdLabeledEdge> graph = ontology.getGraph();
        ArrayList visited = new ArrayList();
        BreadthFirstSearch bfs = new BreadthFirstSearch();
        bfs.startFromForward((DefaultDirectedGraph)graph, sourceID, (g, termId) -> {
            visited.add(termId);
            return true;
        });
        return visited.contains(destID);
    }

    public static Set<TermId> getChildTerms(Ontology ontology, TermId parentTermId) {
        return OntologyAlgorithm.getChildTerms(ontology, parentTermId, true);
    }

    public static Set<TermId> getChildTerms(Ontology ontology, TermId parentTermId, boolean includeOriginalTerm) {
        ImmutableSet.Builder kids = new ImmutableSet.Builder();
        if (includeOriginalTerm) {
            kids.add((Object)parentTermId);
        }
        for (IdLabeledEdge edge : ontology.getGraph().incomingEdgesOf((Object)parentTermId)) {
            TermId sourceId = (TermId)edge.getSource();
            kids.add((Object)sourceId);
        }
        return kids.build();
    }

    public static Set<TermId> getChildTerms(Ontology ontology, Set<TermId> parentTermIdSet) {
        ImmutableSet.Builder kids = new ImmutableSet.Builder();
        for (TermId tid : parentTermIdSet) {
            kids.addAll(OntologyAlgorithm.getChildTerms(ontology, tid));
        }
        return kids.build();
    }

    public static Set<TermId> getParentTerms(Ontology ontology, Set<TermId> childTermIdSet) {
        ImmutableSet.Builder parents = new ImmutableSet.Builder();
        for (TermId tid : childTermIdSet) {
            parents.addAll(OntologyAlgorithm.getParentTerms(ontology, tid));
        }
        return parents.build();
    }

    public static Set<TermId> getParentTerms(Ontology ontology, Set<TermId> childTermIdSet, boolean includeOriginalTerm) {
        ImmutableSet.Builder parents = new ImmutableSet.Builder();
        for (TermId tid : childTermIdSet) {
            parents.addAll(OntologyAlgorithm.getParentTerms(ontology, tid, false));
        }
        return parents.build();
    }

    public static Set<TermId> getDescendents(Ontology ontology, TermId parentTermId) {
        ImmutableSet.Builder descset = new ImmutableSet.Builder();
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        stack.push(parentTermId);
        while (!stack.isEmpty()) {
            TermId tid = (TermId)stack.pop();
            descset.add((Object)tid);
            Set<TermId> directChildrenSet = OntologyAlgorithm.getChildTerms(ontology, tid, false);
            directChildrenSet.forEach(stack::push);
        }
        return descset.build();
    }

    public static Set<TermId> getParentTerms(Ontology ontology, TermId childTermId, boolean includeOriginalTerm) {
        ImmutableSet.Builder anccset = new ImmutableSet.Builder();
        if (includeOriginalTerm) {
            anccset.add((Object)childTermId);
        }
        for (IdLabeledEdge edge : ontology.getGraph().outgoingEdgesOf((Object)childTermId)) {
            int edgeId = edge.getId();
            Relationship rel = ontology.getRelationMap().get(edgeId);
            if (rel == null) {
                logger.error("Could not retrieve relation for id={} [child term={}]", (Object)edgeId, (Object)ontology.getTermMap().get(childTermId).getName());
                continue;
            }
            RelationshipType reltyp = rel.getRelationshipType();
            if (!reltyp.propagates()) continue;
            TermId destId = (TermId)edge.getTarget();
            anccset.add((Object)destId);
        }
        return anccset.build();
    }

    public static Set<TermId> getAncestorTerms(Ontology ontology, TermId rootTerm, Set<TermId> children, boolean includeOriginalTerm) {
        ImmutableOntology subontology = (ImmutableOntology)ontology.subOntology(rootTerm);
        return OntologyAlgorithm.getAncestorTerms((Ontology)subontology, children, includeOriginalTerm);
    }

    public static Set<TermId> getAncestorTerms(Ontology ontology, TermId rootTerm, TermId child, boolean includeOriginalTerm) {
        ImmutableOntology subontology = (ImmutableOntology)ontology.subOntology(rootTerm);
        return OntologyAlgorithm.getAncestorTerms((Ontology)subontology, child, includeOriginalTerm);
    }

    public static Set<TermId> getAncestorTerms(Ontology ontology, Set<TermId> children, boolean includeOriginalTerm) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (includeOriginalTerm) {
            builder.addAll(children);
        }
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        Set<TermId> parents = OntologyAlgorithm.getParentTerms(ontology, children, false);
        for (TermId t : parents) {
            stack.push(t);
        }
        while (!stack.isEmpty()) {
            TermId tid = (TermId)stack.pop();
            builder.add((Object)tid);
            Set<TermId> prnts = OntologyAlgorithm.getParentTerms(ontology, tid, false);
            for (TermId t : prnts) {
                stack.push(t);
            }
        }
        return builder.build();
    }

    public static Set<TermId> getAncestorTerms(Ontology ontology, TermId child, boolean includeOriginalTerm) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (includeOriginalTerm) {
            builder.add((Object)child);
        }
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        Set<TermId> parents = OntologyAlgorithm.getParentTerms(ontology, child, false);
        for (TermId t : parents) {
            stack.push(t);
        }
        while (!stack.isEmpty()) {
            TermId tid = (TermId)stack.pop();
            builder.add((Object)tid);
            Set<TermId> prnts = OntologyAlgorithm.getParentTerms(ontology, tid, false);
            for (TermId t : prnts) {
                stack.push(t);
            }
        }
        return builder.build();
    }

    public static Set<TermId> getParentTerms(Ontology ontology, TermId childTermId) {
        return OntologyAlgorithm.getParentTerms(ontology, childTermId, true);
    }

    public static Set<TermId> getAncestorTerms(Ontology ontology, TermId childTermId) {
        return ontology.getAncestorTermIds(childTermId);
    }

    public static boolean isSubclass(Ontology ontology, TermId source, TermId dest) {
        return ontology.getAncestorTermIds(source).contains(dest);
    }

    public static boolean termsAreSiblings(Ontology ontology, TermId t1, TermId t2) {
        Set<TermId> parents2;
        Set<TermId> parents1 = OntologyAlgorithm.getParentTerms(ontology, t1, false);
        return !Sets.intersection(parents1, parents2 = OntologyAlgorithm.getParentTerms(ontology, t2, false)).isEmpty();
    }

    public static boolean termsAreRelated(Ontology ontology, TermId t1, TermId t2) {
        Set<TermId> ancs1 = OntologyAlgorithm.getAncestorTerms(ontology, t1, false);
        Set<TermId> ancs2 = OntologyAlgorithm.getAncestorTerms(ontology, t2, false);
        Sets.SetView isect = Sets.intersection(ancs1, ancs2);
        for (TermId tid : isect) {
            if (ontology.isRootTerm(tid)) continue;
            return true;
        }
        return false;
    }

    public static boolean termsAreUnrelated(Ontology ontology, TermId t1, TermId t2) {
        return !OntologyAlgorithm.termsAreRelated(ontology, t1, t2);
    }
}

