/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.algo;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.BreadthFirstSearch;
import org.monarchinitiative.phenol.graph.algo.VertexVisitor;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermVisitor;

public final class OntologyTerms {
    public static <O extends Ontology> void visitChildrenOf(TermId termId, final O ontology, final TermVisitor<O> termVisitor) {
        BreadthFirstSearch bfs = new BreadthFirstSearch();
        DefaultDirectedGraph<TermId, IdLabeledEdge> graph = ontology.getGraph();
        bfs.startFromReverse((DefaultDirectedGraph)graph, termId, (VertexVisitor)new VertexVisitor<TermId, IdLabeledEdge>(){

            @Override
            public boolean visit(DefaultDirectedGraph<TermId, IdLabeledEdge> g, TermId v) {
                return termVisitor.visit(ontology, v);
            }
        });
    }

    public static <O extends Ontology> Set<TermId> childrenOf(TermId termId, O ontology) {
        final HashSet<TermId> result = new HashSet<TermId>();
        OntologyTerms.visitChildrenOf(termId, ontology, new TermVisitor<O>(){

            @Override
            public boolean visit(O ontology, TermId termId) {
                result.add(termId);
                return true;
            }
        });
        return result;
    }

    public static <O extends Ontology> void visitParentsOf(TermId termId, final O ontology, final TermVisitor<O> termVisitor) {
        BreadthFirstSearch bfs = new BreadthFirstSearch();
        DefaultDirectedGraph<TermId, IdLabeledEdge> graph = ontology.getGraph();
        bfs.startFromForward((DefaultDirectedGraph)graph, termId, (VertexVisitor)new VertexVisitor<TermId, IdLabeledEdge>(){

            @Override
            public boolean visit(DefaultDirectedGraph<TermId, IdLabeledEdge> g, TermId v) {
                return termVisitor.visit(ontology, v);
            }
        });
    }

    public static <O extends Ontology> Set<TermId> parentsOf(TermId termId, O ontology) {
        final HashSet<TermId> result = new HashSet<TermId>();
        OntologyTerms.visitParentsOf(termId, ontology, new TermVisitor<O>(){

            @Override
            public boolean visit(O ontology, TermId termId) {
                result.add(termId);
                return true;
            }
        });
        return result;
    }
}

