/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.ontology.data.Relationship;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface MinimalOntology
extends Serializable {
    public static final long serialVersionUID = 2L;

    public Map<String, String> getMetaInfo();

    public DefaultDirectedGraph<TermId, IdLabeledEdge> getGraph();

    public Map<TermId, Term> getTermMap();

    public Map<Integer, Relationship> getRelationMap();

    default public boolean isRootTerm(TermId termId) {
        return this.getRootTermId().equals(termId);
    }

    public TermId getRootTermId();

    public Set<TermId> getAllTermIds();

    public Set<TermId> getNonObsoleteTermIds();

    public Set<TermId> getObsoleteTermIds();

    public Collection<Term> getTerms();

    default public int countAllTerms() {
        return this.getNonObsoleteTermIds().size();
    }

    default public int countObsoleteTerms() {
        return this.getObsoleteTermIds().size();
    }

    default public int countNonObsoleteTerms() {
        return this.getNonObsoleteTermIds().size();
    }
}

