/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.monarchinitiative.phenol.graph.util.GraphUtil;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface Ontology
extends MinimalOntology,
Serializable {
    public static final long serialVersionUID = 2L;

    default public TermId getPrimaryTermId(TermId termId) {
        Term term = this.getTermMap().get(termId);
        if (term == null) {
            return null;
        }
        return term.getId();
    }

    public Set<TermId> getAncestorTermIds(TermId var1, boolean var2);

    default public Set<TermId> getAncestorTermIds(TermId termId) {
        return this.getAncestorTermIds(termId, true);
    }

    public Set<TermId> getAllAncestorTermIds(Collection<TermId> var1, boolean var2);

    default public Set<TermId> getAllAncestorTermIds(Collection<TermId> termIds) {
        return this.getAllAncestorTermIds(termIds, true);
    }

    default public Set<TermId> getParentTermIds(TermId termId) {
        HashSet<TermId> result = new HashSet<TermId>();
        Iterator<TermId> it = GraphUtil.viaOutEdgeIterator(this.getGraph(), termId);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public Ontology subOntology(TermId var1);
}

