/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

public class SimpleXref {
    private final Prefix prefix;
    private final String id;

    public SimpleXref(String xref) {
        int i = xref.indexOf(58);
        if (i < 1 || i == xref.length() - 1) {
            this.prefix = Prefix.UNKNOWN;
            this.id = xref;
        } else {
            String pre = xref.substring(0, i);
            this.id = xref.substring(i + 1);
            switch (pre.toUpperCase()) {
                case "HPO": {
                    this.prefix = Prefix.HPO;
                    break;
                }
                case "PMID": {
                    this.prefix = Prefix.PMID;
                    break;
                }
                case "MGI": {
                    this.prefix = Prefix.MGI;
                    break;
                }
                case "ISBN": {
                    this.prefix = Prefix.ISBN;
                    break;
                }
                case "MONDO": {
                    this.prefix = Prefix.MONDO;
                    break;
                }
                case "NCIT": {
                    this.prefix = Prefix.NCIT;
                    break;
                }
                case "ORCID": {
                    this.prefix = Prefix.ORCID;
                    break;
                }
                case "MESH": {
                    this.prefix = Prefix.MESH;
                    break;
                }
                case "DOID": {
                    this.prefix = Prefix.DOID;
                    break;
                }
                case "ORPHANET": {
                    this.prefix = Prefix.ORPHANET;
                    break;
                }
                case "EFO": {
                    this.prefix = Prefix.EFO;
                    break;
                }
                default: {
                    this.prefix = Prefix.UNKNOWN;
                }
            }
        }
    }

    public boolean isPmid() {
        return this.prefix.equals((Object)Prefix.PMID);
    }

    public boolean isIsbn() {
        return this.prefix.equals((Object)Prefix.ISBN);
    }

    public boolean isHpo() {
        return this.prefix.equals((Object)Prefix.HPO);
    }

    public boolean isMgi() {
        return this.prefix.equals((Object)Prefix.MGI);
    }

    public boolean isValid() {
        return !this.prefix.equals((Object)Prefix.UNKNOWN);
    }

    public String getCurie() {
        return this.prefix.name + ":" + this.id;
    }

    public String getPrefix() {
        return this.prefix.toString();
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.getCurie();
    }

    static enum Prefix {
        HPO("HPO"),
        MGI("MGI"),
        PMID("PMID"),
        ISBN("ISBN"),
        MONDO("MONDO"),
        NCIT("NCIT"),
        ORCID("ORCID"),
        MESH("MESH"),
        DOID("DOID"),
        ORPHANET("Orphanet"),
        EFO("EFO"),
        UNKNOWN("?");

        private final String name;

        private Prefix(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

