/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class TermAnnotations {
    private TermAnnotations() {
    }

    public static Map<TermId, Collection<TermId>> constructTermAnnotationToLabelsMap(Ontology ontology, Collection<? extends TermAnnotation> annotations) {
        HashMap<TermId, Collection<TermId>> result = new HashMap<TermId, Collection<TermId>>();
        for (TermAnnotation termAnnotation : annotations) {
            for (TermId termId : ontology.getAncestorTermIds(termAnnotation.getTermId(), true)) {
                if (!result.containsKey(termId)) {
                    result.put(termId, Sets.newHashSet((Object[])new TermId[]{termAnnotation.getLabel()}));
                    continue;
                }
                ((Collection)result.get(termId)).add(termAnnotation.getLabel());
            }
        }
        return result;
    }

    public static Map<TermId, Collection<TermId>> constructTermLabelToAnnotationsMap(Ontology ontology, Collection<? extends TermAnnotation> annotations) {
        HashMap<TermId, Collection<TermId>> result = new HashMap<TermId, Collection<TermId>>();
        for (TermAnnotation termAnnotation : annotations) {
            for (TermId termId : ontology.getAncestorTermIds(termAnnotation.getTermId(), true)) {
                if (!result.containsKey(termAnnotation.getLabel())) {
                    result.put(termAnnotation.getLabel(), Sets.newHashSet((Object[])new TermId[]{termId}));
                    continue;
                }
                ((Collection)result.get(termAnnotation.getLabel())).add(termId);
            }
        }
        return result;
    }
}

