/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.Similarity;

public final class CosineSimilarity
implements Similarity {
    private final Ontology ontology;
    private final boolean oppositeAware;

    public CosineSimilarity(Ontology ontology) {
        this(ontology, false);
    }

    public CosineSimilarity(Ontology ontology, boolean oppositeAware) {
        this.ontology = ontology;
        this.oppositeAware = oppositeAware;
    }

    @Override
    public String getName() {
        return "Cosine similarity";
    }

    @Override
    public String getParameters() {
        return "{oppositeAware: " + this.oppositeAware + "}";
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public double computeScore(Collection<TermId> query, Collection<TermId> target) {
        Set<TermId> termIdsQuery = this.ontology.getAllAncestorTermIds(query, false);
        Set<TermId> termIdsTarget = this.ontology.getAllAncestorTermIds(target, false);
        return (double)Sets.intersection(termIdsQuery, termIdsTarget).size() / (Math.sqrt(termIdsQuery.size()) * Math.sqrt(termIdsTarget.size()));
    }
}

