/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.PairwiseSimilarity;

public final class PairwiseResnikSimilarity
implements PairwiseSimilarity {
    private final Ontology ontology;
    private final Map<TermId, Double> termToIc;

    protected PairwiseResnikSimilarity() {
        this.ontology = null;
        this.termToIc = null;
    }

    public PairwiseResnikSimilarity(Ontology ontology, Map<TermId, Double> termToIc) {
        this.ontology = ontology;
        this.termToIc = termToIc;
    }

    private double computeScoreImpl(TermId query, TermId target) {
        Set<TermId> queryTerms = this.getOntology().getAncestorTermIds(query, true);
        Set<TermId> targetTerms = this.getOntology().getAncestorTermIds(target, true);
        double maxValue = 0.0;
        for (TermId termId : queryTerms) {
            if (!targetTerms.contains(termId)) continue;
            maxValue = Double.max(maxValue, this.getTermToIc().get(termId));
        }
        return maxValue;
    }

    @Override
    public double computeScore(TermId query, TermId target) {
        return this.computeScoreImpl(query, target);
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public Map<TermId, Double> getTermToIc() {
        return this.termToIc;
    }
}

