/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.PairwiseResnikSimilarity;
import org.monarchinitiative.phenol.ontology.similarity.PairwiseSimilarity;
import org.monarchinitiative.phenol.utils.ProgressReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrecomputingPairwiseResnikSimilarity
implements PairwiseSimilarity,
Serializable {
    private static final long serialVersionUID = -350622665214125471L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrecomputingPairwiseResnikSimilarity.class);
    private PrecomputedScores precomputedScores;
    private final int numThreads;
    private final int chunkSize = 100;

    public PrecomputingPairwiseResnikSimilarity(Ontology ontology, Map<TermId, Double> termToIc, int numThreads) {
        this.precomputedScores = new PrecomputedScores(ontology.getAllTermIds());
        this.numThreads = numThreads;
        this.precomputeScores(ontology, termToIc);
    }

    public PrecomputingPairwiseResnikSimilarity(Ontology ontology, Map<TermId, Double> termToIc) {
        this(ontology, termToIc, 1);
    }

    private void precomputeScores(Ontology ontology, Map<TermId, Double> termToIc) {
        LOGGER.info("Precomputing pairwise scores for {} terms...", new Object[]{ontology.countAllTerms()});
        PairwiseResnikSimilarity pairwiseSimilarity = new PairwiseResnikSimilarity(ontology, termToIc);
        ProgressReporter progressReport = new ProgressReporter(LOGGER, "objects", ontology.countAllTerms());
        progressReport.start();
        Consumer<List> task = chunk -> {
            try {
                for (TermId queryId : chunk) {
                    for (TermId targetId : ontology.getNonObsoleteTermIds()) {
                        if (queryId.compareTo(targetId) > 0) continue;
                        this.precomputedScores.put(queryId, targetId, pairwiseSimilarity.computeScore(queryId, targetId));
                    }
                    progressReport.incCurrent();
                }
            }
            catch (Exception e) {
                System.err.print("An exception occured in parallel processing!");
                e.printStackTrace();
            }
        };
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 5L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>());
        List chunks = Lists.partition((List)Lists.newArrayList(ontology.getNonObsoleteTermIds()), (int)100);
        for (List chunk2 : chunks) {
            threadPoolExecutor.submit(() -> task.accept(chunk2));
        }
        threadPoolExecutor.shutdown();
        try {
            threadPoolExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not wait for thread pool being done.", e);
        }
        progressReport.stop();
        LOGGER.info("Done precomputing pairwise scores.");
    }

    @Override
    public double computeScore(TermId query, TermId target) {
        return this.precomputedScores.get(query, target);
    }

    private static final class PrecomputedScores
    implements Serializable {
        private static final long serialVersionUID = -6390653194662991513L;
        private final HashMap<TermId, Integer> termIdToIdx;
        private final float[] data;
        private final int termIdCount;

        PrecomputedScores(Collection<TermId> termIds) {
            this.termIdCount = termIds.size();
            this.data = new float[this.termIdCount * this.termIdCount];
            this.termIdToIdx = new HashMap(this.termIdCount);
            int i = 0;
            for (TermId termId : ImmutableSortedSet.copyOf(termIds)) {
                this.termIdToIdx.put(termId, i++);
            }
        }

        public void put(TermId lhs, TermId rhs, double value) {
            this.put(lhs, rhs, (float)value);
        }

        public void put(TermId lhs, TermId rhs, float value) {
            int idxLhs = this.termIdToIdx.get(lhs);
            int idxRhs = this.termIdToIdx.get(rhs);
            this.data[idxLhs * this.termIdCount + idxRhs] = value;
            this.data[idxRhs * this.termIdCount + idxLhs] = value;
        }

        public float get(TermId lhs, TermId rhs) {
            Integer idxLhs = this.termIdToIdx.get(lhs);
            Integer idxRhs = this.termIdToIdx.get(rhs);
            if (idxLhs == null || idxRhs == null) {
                return 0.0f;
            }
            return this.data[idxLhs * this.termIdCount + idxRhs];
        }
    }
}

