/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.Similarity;

public final class TermOverlapSimilarity
implements Similarity {
    private final Ontology ontology;
    private final boolean normalized;

    public TermOverlapSimilarity(Ontology ontology) {
        this(ontology, true);
    }

    public TermOverlapSimilarity(Ontology ontology, boolean normalized) {
        this.ontology = ontology;
        this.normalized = normalized;
    }

    @Override
    public String getName() {
        return "TermI overlap similarity";
    }

    @Override
    public String getParameters() {
        return "{normalized: " + this.normalized + "}";
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public double computeScore(Collection<TermId> query, Collection<TermId> target) {
        Set<TermId> termIdsQuery = this.ontology.getAllAncestorTermIds(query, false);
        Set<TermId> termIdsTarget = this.ontology.getAllAncestorTermIds(target, false);
        double overlap = Sets.intersection(termIdsQuery, termIdsTarget).size();
        if (!this.normalized) {
            return overlap;
        }
        return overlap / (double)Math.min(termIdsQuery.size(), termIdsTarget.size());
    }
}

