/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser;

import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.AutoValue_ServiceElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.OptionElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.RpcElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ServiceElement {
    public static Builder builder() {
        return new Builder();
    }

    public abstract String name();

    public abstract String qualifiedName();

    public abstract String documentation();

    public abstract List<RpcElement> rpcs();

    public abstract List<OptionElement> options();

    ServiceElement() {
    }

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("service ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Utils.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.rpcs().isEmpty()) {
            builder.append('\n');
            for (RpcElement rpc : this.rpcs()) {
                Utils.appendIndented(builder, rpc.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Builder {
        private String name;
        private String qualifiedName;
        private String documentation = "";
        private final List<OptionElement> options = new ArrayList<OptionElement>();
        private final List<RpcElement> rpcs = new ArrayList<RpcElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            if (this.qualifiedName == null) {
                this.qualifiedName = name;
            }
            return this;
        }

        public Builder qualifiedName(String qualifiedName) {
            this.qualifiedName = Utils.checkNotNull(qualifiedName, "qualifiedName");
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addRpc(RpcElement rpc) {
            this.rpcs.add(Utils.checkNotNull(rpc, "rpc"));
            return this;
        }

        public Builder addRpcs(Collection<RpcElement> rpcs) {
            for (RpcElement rpc : Utils.checkNotNull(rpcs, "rpcs")) {
                this.addRpc(rpc);
            }
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public ServiceElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.qualifiedName, "qualifiedName");
            return new AutoValue_ServiceElement(this.name, this.qualifiedName, this.documentation, Utils.immutableCopyOf(this.rpcs), Utils.immutableCopyOf(this.options));
        }
    }
}

