/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners.biolark;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import org.monarchinitiative.hpotextmining.core.miners.biolark.BiolarkToken;

public final class BiolarkResult {
    private final int start;
    private final int end;
    private final int length;
    private final String original_text;
    private final String source;
    private final BiolarkToken term;
    private final boolean negated;

    @JsonCreator
    public BiolarkResult(@JsonProperty(value="start_offset") int start, @JsonProperty(value="end_offset") int end, @JsonProperty(value="length") int length, @JsonProperty(value="original_text") String original_text, @JsonProperty(value="source") String source, @JsonProperty(value="term") BiolarkToken term, @JsonProperty(value="negated") boolean negated) {
        this.start = start;
        this.end = end;
        this.length = length;
        this.original_text = original_text;
        this.source = source;
        this.term = term;
        this.negated = negated;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public String getOriginal_text() {
        return this.original_text;
    }

    public String getSource() {
        return this.source;
    }

    public BiolarkToken getTerm() {
        return this.term;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.length;
        result = 31 * result + this.original_text.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.term.hashCode();
        result = 31 * result + (this.negated ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiolarkResult that = (BiolarkResult)o;
        if (this.start != that.start) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.negated != that.negated) {
            return false;
        }
        if (!this.original_text.equals(that.original_text)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.term.equals(that.term);
    }

    public String toString() {
        return "BiolarkResult{start=" + this.start + ", end=" + this.end + ", length=" + this.length + ", original_text='" + this.original_text + '\'' + ", source='" + this.source + '\'' + ", term=" + this.term + ", negated=" + this.negated + '}';
    }

    public static Comparator<BiolarkResult> compareByStart() {
        return (left, right) -> ComparisonChain.start().compare(left.getStart(), right.getStart()).result();
    }

    public static Comparator<BiolarkResult> compareByName() {
        return (left, right) -> ComparisonChain.start().compare((Comparable)((Object)left.getTerm().getLabel()), (Comparable)((Object)right.getTerm().getLabel())).result();
    }
}

