/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners.biolark;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class BiolarkToken {
    private final String id;
    private String label;
    private final Set<String> synonyms;

    @JsonCreator
    public BiolarkToken(@JsonProperty(value="uri") String id, @JsonProperty(value="preferredLabel") String label, @JsonProperty(value="synonyms") Set<String> synonyms) {
        this.id = id;
        this.label = label;
        this.synonyms = synonyms;
    }

    public String getId() {
        return this.id;
    }

    public TermId getTermId() {
        return TermId.of((String)this.id);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Set<String> getSynonyms() {
        return new HashSet<String>(this.synonyms);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiolarkToken term = (BiolarkToken)o;
        return this.getId().equals(term.getId());
    }

    public String toString() {
        return "BiolarkToken{id='" + this.id + '\'' + ", label='" + this.label + '\'' + ", synonyms='" + String.join((CharSequence)", ", this.synonyms) + "'" + '}';
    }
}

