/*
 * Decompiled with CFR 0.152.
 */
package org.prefixcommons;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.prefixcommons.trie.Trie;

public class CurieUtil {
    private final Trie trie;
    private final ImmutableBiMap<String, String> curieMap;

    public CurieUtil(Map<String, String> mapping) {
        Collection<String> iris = mapping.values();
        this.curieMap = ImmutableBiMap.copyOf(mapping);
        this.trie = new Trie();
        for (String key : iris) {
            this.trie.insert(key);
        }
    }

    public static CurieUtil fromJsonLdFile(String filePath) throws IOException {
        FileInputStream inputStream = new FileInputStream(filePath);
        Object jsonObject = JsonUtils.fromInputStream((InputStream)inputStream);
        Context context = CurieUtil.parseContext(jsonObject);
        return new CurieUtil(context.getPrefixes(false));
    }

    private static Context parseContext(Object jsonObject) throws IOException {
        try {
            if (!(jsonObject instanceof Map)) {
                return null;
            }
            Map jsonMap = (Map)jsonObject;
            if (!jsonMap.containsKey("@context")) {
                return null;
            }
            Object jsonContext = jsonMap.get("@context");
            return new Context().parse(jsonContext);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Collection<String> getPrefixes() {
        return this.curieMap.keySet();
    }

    public String getExpansion(String curiePrefix) {
        return (String)this.curieMap.get((Object)curiePrefix);
    }

    public Optional<String> getCurie(String iri) {
        String prefix = this.trie.getMatchingPrefix(iri);
        if (prefix.equals("")) {
            return Optional.empty();
        }
        String curiePrefix = (String)this.curieMap.inverse().get((Object)prefix);
        return Optional.of(curiePrefix + ":" + iri.substring(prefix.length(), iri.length()));
    }

    public Optional<String> getIri(String curie) {
        String prefix;
        String[] parts = ((String)Preconditions.checkNotNull((Object)curie)).split(":");
        if (parts.length > 1 && this.curieMap.containsKey((Object)(prefix = parts[0]))) {
            return Optional.of((String)this.curieMap.get((Object)prefix) + curie.substring(curie.indexOf(58) + 1));
        }
        return Optional.empty();
    }

    public Map<String, String> getCurieMap() {
        return this.curieMap;
    }
}

