/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.vertexcover;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.MinimumVertexCoverAlgorithm;
import org.jgrapht.alg.interfaces.MinimumWeightedVertexCoverAlgorithm;
import org.jgrapht.alg.interfaces.VertexCoverAlgorithm;
import org.jgrapht.graph.AsSubgraph;

public class BarYehudaEvenTwoApproxVCImpl<V, E>
implements MinimumWeightedVertexCoverAlgorithm<V, E>,
VertexCoverAlgorithm<V> {
    private final Graph<V, E> graph;
    private final Map<V, Double> vertexWeightMap;

    @Deprecated
    public BarYehudaEvenTwoApproxVCImpl() {
        this.graph = null;
        this.vertexWeightMap = null;
    }

    public BarYehudaEvenTwoApproxVCImpl(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph);
        this.vertexWeightMap = graph.vertexSet().stream().collect(Collectors.toMap(Function.identity(), vertex -> 1.0));
    }

    public BarYehudaEvenTwoApproxVCImpl(Graph<V, E> graph, Map<V, Double> vertexWeightMap) {
        this.graph = GraphTests.requireUndirected(graph);
        this.vertexWeightMap = Objects.requireNonNull(vertexWeightMap);
    }

    @Override
    public VertexCoverAlgorithm.VertexCover getVertexCover() {
        LinkedHashSet cover = new LinkedHashSet();
        double weight = 0.0;
        AsSubgraph copy = new AsSubgraph(this.graph, null, null);
        HashMap W = new HashMap();
        for (V v : this.graph.vertexSet()) {
            W.put(v, this.vertexWeightMap.get(v));
        }
        Set edgeSet = copy.edgeSet();
        while (!edgeSet.isEmpty()) {
            Object e = edgeSet.iterator().next();
            Object p = copy.getEdgeSource(e);
            Object q = copy.getEdgeTarget(e);
            if ((Double)W.get(p) <= (Double)W.get(q)) {
                W.put(q, (Double)W.get(q) - (Double)W.get(p));
                cover.add(p);
                weight += this.vertexWeightMap.get(p).doubleValue();
                copy.removeVertex(p);
                continue;
            }
            W.put(p, (Double)W.get(p) - (Double)W.get(q));
            cover.add(q);
            weight += this.vertexWeightMap.get(q).doubleValue();
            copy.removeVertex(q);
        }
        return new VertexCoverAlgorithm.VertexCoverImpl(cover, weight);
    }

    @Override
    @Deprecated
    public MinimumVertexCoverAlgorithm.VertexCover<V> getVertexCover(Graph<V, E> graph, Map<V, Double> vertexWeightMap) {
        GraphTests.requireUndirected(graph);
        LinkedHashSet cover = new LinkedHashSet();
        double weight = 0.0;
        AsSubgraph copy = new AsSubgraph(graph, null, null);
        HashMap W = new HashMap();
        for (V v : graph.vertexSet()) {
            W.put(v, vertexWeightMap.get(v));
        }
        Set edgeSet = copy.edgeSet();
        while (!edgeSet.isEmpty()) {
            Object e = edgeSet.iterator().next();
            Object p = copy.getEdgeSource(e);
            Object q = copy.getEdgeTarget(e);
            if ((Double)W.get(p) <= (Double)W.get(q)) {
                W.put(q, (Double)W.get(q) - (Double)W.get(p));
                cover.add(p);
                weight += vertexWeightMap.get(p).doubleValue();
                copy.removeVertex(p);
                continue;
            }
            W.put(p, (Double)W.get(p) - (Double)W.get(q));
            cover.add(q);
            weight += vertexWeightMap.get(q).doubleValue();
            copy.removeVertex(q);
        }
        return new MinimumVertexCoverAlgorithm.VertexCoverImpl(cover, weight);
    }
}

