/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.io.Serializable;
import java.util.UUID;
import java.util.function.Supplier;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;

public class SupplierUtil {
    public static final Supplier<DefaultEdge> DEFAULT_EDGE_SUPPLIER = SupplierUtil.createSupplier(DefaultEdge.class);
    public static final Supplier<DefaultWeightedEdge> DEFAULT_WEIGHTED_EDGE_SUPPLIER = SupplierUtil.createSupplier(DefaultWeightedEdge.class);
    public static final Supplier<Object> OBJECT_SUPPLIER = SupplierUtil.createSupplier(Object.class);

    public static <T> Supplier<T> createSupplier(Class<? extends T> clazz) {
        return (Supplier<Object> & Serializable)() -> {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Supplier failed", ex);
            }
        };
    }

    public static Supplier<DefaultEdge> createDefaultEdgeSupplier() {
        return SupplierUtil.createSupplier(DefaultEdge.class);
    }

    public static Supplier<DefaultWeightedEdge> createDefaultWeightedEdgeSupplier() {
        return SupplierUtil.createSupplier(DefaultWeightedEdge.class);
    }

    public static Supplier<Integer> createIntegerSupplier() {
        return new IntegerSupplier(0);
    }

    public static Supplier<Integer> createIntegerSupplier(int start) {
        return new IntegerSupplier(start);
    }

    public static Supplier<Long> createLongSupplier() {
        return new LongSupplier(0L);
    }

    public static Supplier<Long> createLongSupplier(long start) {
        return new LongSupplier(start);
    }

    public static Supplier<String> createStringSupplier() {
        return new StringSupplier(0);
    }

    public static Supplier<String> createRandomUUIDStringSupplier() {
        return new RandomUUIDStringSupplier();
    }

    public static Supplier<String> createStringSupplier(int start) {
        return new StringSupplier(start);
    }

    private static class RandomUUIDStringSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = -4636552536822031851L;

        private RandomUUIDStringSupplier() {
        }

        @Override
        public String get() {
            return UUID.randomUUID().toString();
        }
    }

    private static class StringSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = -5025488316341437260L;
        private int i = 0;

        public StringSupplier(int start) {
            this.i = start;
        }

        @Override
        public String get() {
            return String.valueOf(this.i++);
        }
    }

    private static class LongSupplier
    implements Supplier<Long>,
    Serializable {
        private static final long serialVersionUID = 4994477932143967277L;
        private long i = 0L;

        public LongSupplier(long start) {
            this.i = start;
        }

        @Override
        public Long get() {
            return this.i++;
        }
    }

    private static class IntegerSupplier
    implements Supplier<Integer>,
    Serializable {
        private static final long serialVersionUID = -4714266728630636497L;
        private int i = 0;

        public IntegerSupplier(int start) {
            this.i = start;
        }

        @Override
        public Integer get() {
            return this.i++;
        }
    }
}

