/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.geneontology.obographs.model.Graph;
import org.geneontology.obographs.model.Meta;

public class GraphDocument {
    private final List<Graph> graphs;
    private final Meta meta;
    @JsonProperty(value="@context")
    private final Object context;

    private GraphDocument(Builder builder) {
        this.meta = builder.meta;
        this.graphs = builder.graphs;
        this.context = builder.context;
    }

    public List<Graph> getGraphs() {
        return this.graphs;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public static class Builder {
        @JsonProperty
        private Meta meta;
        @JsonProperty
        private List<Graph> graphs;
        @JsonProperty
        private Object context;

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder graphs(List<Graph> graphs) {
            this.graphs = graphs;
            return this;
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public GraphDocument build() {
            return new GraphDocument(this);
        }
    }
}

