/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import ioinformarics.oss.jackson.module.jsonld.JsonldContextFactory;
import ioinformarics.oss.jackson.module.jsonld.JsonldGraph;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.JsonldResourceBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;

public class JsonldGraphBuilder<T> {
    protected String context;
    protected String graphType;
    protected String graphId;
    protected JsonldResourceBuilder<T> resourceBuilder = new JsonldResourceBuilder();
    protected Function<T, String> typeSupplier;

    JsonldGraphBuilder() {
    }

    public JsonldGraphBuilder<T> context(String context) {
        this.context = context;
        return this;
    }

    public JsonldGraphBuilder<T> type(String type) {
        this.graphType = type;
        return this;
    }

    public JsonldGraphBuilder<T> id(String id) {
        this.graphId = id;
        return this;
    }

    public JsonldGraphBuilder<T> elementId(Function<T, String> idSupplier) {
        this.resourceBuilder.id(idSupplier);
        return this;
    }

    public JsonldGraphBuilder<T> elementType(Function<T, String> typeSupplier) {
        this.typeSupplier = typeSupplier;
        return this;
    }

    public JsonldResource build(Iterable<T> elements) {
        Optional<JsonNode> generatedContext = JsonldContextFactory.multiContext(Optional.ofNullable(this.context), JsonldContextFactory.fromAnnotations(elements));
        return new JsonldGraph(this.buildElements(elements), (JsonNode)generatedContext.orElse(null), this.graphType, this.graphId);
    }

    protected String getType(T e) {
        return this.typeSupplier.apply(e);
    }

    protected Iterable<JsonldResource> buildElements(Iterable<T> elements) {
        ArrayList<JsonldResource> list = new ArrayList<JsonldResource>();
        elements.forEach(e -> {
            JsonldResourceBuilder<Object> builder = JsonldResource.Builder.create();
            builder.type(this.resourceBuilder.getType(e));
            builder.id(this.resourceBuilder.getId(e));
            builder.context(null);
            list.add(builder.build(e));
        });
        return list;
    }
}

