/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld.internal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import ioinformarics.oss.jackson.module.jsonld.BeanJsonldResource;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldLink;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JsonldResourceSerializerModifier
extends BeanSerializerModifier {
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (BeanJsonldResource.class.isAssignableFrom(beanDesc.getBeanClass()) && serializer instanceof BeanSerializerBase) {
            return new BeanSerializer((BeanSerializerBase)serializer){

                protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                    super.serializeFields(bean, jgen, provider);
                    JsonldResourceSerializerModifier.this.getLinks((BeanJsonldResource)bean).ifPresent(linksMap -> linksMap.forEach((key, value) -> {
                        try {
                            jgen.writeFieldName(key);
                            jgen.writeString(value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }));
                }
            };
        }
        return serializer;
    }

    protected Optional<Map<String, String>> getLinks(BeanJsonldResource resource) {
        HashMap<String, String> linksNodes = null;
        Class<?> beanType = resource.scopedObj.getClass();
        JsonldLink[] links = (JsonldLink[])beanType.getAnnotationsByType(JsonldLink.class);
        if (links != null) {
            linksNodes = new HashMap<String, String>(links.length);
            for (int i = 0; i < links.length; ++i) {
                linksNodes.put(links[i].name(), links[i].href());
            }
        }
        return Optional.ofNullable(linksNodes);
    }
}

