/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.gui.controller;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Callback;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;
import org.monarchinitiative.hpotextmining.core.miners.TermMiner;
import org.monarchinitiative.hpotextmining.core.miners.biolark.BiolarkTermMiner;
import org.monarchinitiative.hpotextmining.core.miners.scigraph.SciGraphTermMiner;
import org.monarchinitiative.hpotextmining.gui.controller.Configure;
import org.monarchinitiative.hpotextmining.gui.controller.Main;
import org.monarchinitiative.hpotextmining.gui.controller.OntologyTree;
import org.monarchinitiative.hpotextmining.gui.controller.Present;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpoTextMining {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoTextMining.class);
    private final Parent mainParent;
    private Main main = new Main();
    private Configure configure;
    private Node configureAnchorPane;
    private Present present;
    private Node presentVBox;
    private OntologyTree ontologyTree;

    private HpoTextMining(Ontology ontology, TermMiner miner, ExecutorService executorService, Set<Main.PhenotypeTerm> presentTerms) throws IOException {
        Consumer<Main.Signal> configureSignal = signal -> {
            switch (signal) {
                case DONE: {
                    Set<Main.PhenotypeTerm> phenotypeTerms = this.configure.getTerms().stream().map(HpoTextMining.minedTermToPhenotypeTerm(ontology)).filter(Objects::nonNull).collect(Collectors.toSet());
                    this.present.setResults(phenotypeTerms, this.configure.getQuery());
                    this.main.setTextMiningContent(this.presentVBox);
                    break;
                }
                case FAILED: {
                    LOGGER.warn("Sorry, text mining analysis failed.");
                    break;
                }
                case CANCELLED: {
                    LOGGER.warn("Text mining analysis cancelled");
                }
            }
        };
        this.configure = new Configure(miner, executorService, configureSignal);
        Consumer<Main.Signal> presentSignal = signal -> {
            switch (signal) {
                case DONE: {
                    this.main.addPhenotypeTerms(this.present.getApprovedTerms());
                    this.main.setTextMiningContent(this.configureAnchorPane);
                    break;
                }
                case FAILED: {
                    LOGGER.warn("Sorry, text mining analysis failed.");
                    break;
                }
                case CANCELLED: {
                    LOGGER.warn("Text mining analysis cancelled");
                    break;
                }
                default: {
                    LOGGER.warn("Unknown option '{}'", (Object)signal);
                }
            }
        };
        this.present = new Present(presentSignal, termId -> this.ontologyTree.focusOnTerm((Term)ontology.getTermMap().get(termId)));
        Consumer<Main.PhenotypeTerm> addHook = this.main::addPhenotypeTerm;
        this.ontologyTree = new OntologyTree(ontology, addHook);
        Callback controllerFactory = clazz -> {
            if (clazz.equals(Main.class)) {
                return this.main;
            }
            if (clazz.equals(Configure.class)) {
                return this.configure;
            }
            if (clazz.equals(Present.class)) {
                return this.present;
            }
            if (clazz.equals(OntologyTree.class)) {
                return this.ontologyTree;
            }
            LOGGER.warn("Unknown class '{}' requested", clazz);
            return null;
        };
        FXMLLoader mainLoader = new FXMLLoader(this.getClass().getResource("Main.fxml"));
        mainLoader.setControllerFactory(controllerFactory);
        this.mainParent = (Parent)mainLoader.load();
        FXMLLoader configureLoader = new FXMLLoader(this.getClass().getResource("Configure.fxml"));
        configureLoader.setControllerFactory(controllerFactory);
        this.configureAnchorPane = (Node)configureLoader.load();
        this.main.setTextMiningContent(this.configureAnchorPane);
        FXMLLoader presentLoader = new FXMLLoader(this.getClass().getResource("Present.fxml"));
        presentLoader.setControllerFactory(controllerFactory);
        this.presentVBox = (Node)presentLoader.load();
        FXMLLoader ontologyTreeLoader = new FXMLLoader(this.getClass().getResource("OntologyTree.fxml"));
        ontologyTreeLoader.setControllerFactory(controllerFactory);
        this.main.setLeftStackPaneContent((Node)ontologyTreeLoader.load());
        this.main.addPhenotypeTerms(presentTerms);
    }

    private static Function<MinedTerm, Main.PhenotypeTerm> minedTermToPhenotypeTerm(Ontology ontology) {
        return mt -> {
            TermId termId = TermId.of((String)mt.getTermId());
            if (!termId.getValue().startsWith("HP")) {
                return null;
            }
            Term term = (Term)ontology.getTermMap().get(termId);
            if (term == null) {
                LOGGER.warn("There is not a term with id '{}' in the currently used ontology", (Object)termId.getValue());
                return null;
            }
            return new Main.PhenotypeTerm(term, (MinedTerm)mt);
        };
    }

    public static HpoTextMiningBuilder builder() {
        return new HpoTextMiningBuilder();
    }

    public Parent getMainParent() {
        return this.mainParent;
    }

    public Set<Main.PhenotypeTerm> getApprovedTerms() {
        return this.main.getPhenotypeTerms();
    }

    public static final class HpoTextMiningBuilder {
        private Ontology ontology;
        private URL biolarkServerUrl;
        private URL sciGraphServerUrl;
        private TermMiner miner;
        private ExecutorService executorService;
        private Set<Main.PhenotypeTerm> terms = new HashSet<Main.PhenotypeTerm>();

        private HpoTextMiningBuilder() {
        }

        public HpoTextMiningBuilder withOntology(Ontology ontology) {
            this.ontology = ontology;
            return this;
        }

        public HpoTextMiningBuilder withBiolarkUrl(URL biolarkServerUrl) {
            this.biolarkServerUrl = biolarkServerUrl;
            return this;
        }

        public HpoTextMiningBuilder withSciGraphUrl(URL sciGraphServerUrl) {
            this.sciGraphServerUrl = sciGraphServerUrl;
            return this;
        }

        public HpoTextMiningBuilder withTermMiner(TermMiner miner) {
            this.miner = miner;
            return this;
        }

        public HpoTextMiningBuilder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public HpoTextMiningBuilder withPhenotypeTerms(Set<Main.PhenotypeTerm> terms) {
            this.terms.addAll(terms);
            return this;
        }

        public HpoTextMining build() throws IOException {
            TermMiner usedMiner;
            if (this.miner != null) {
                usedMiner = this.miner;
            } else if (this.sciGraphServerUrl != null) {
                LOGGER.info("Using '{}' as url for text mining server", (Object)this.sciGraphServerUrl);
                usedMiner = new SciGraphTermMiner(this.sciGraphServerUrl);
            } else if (this.biolarkServerUrl != null) {
                usedMiner = new BiolarkTermMiner(this.biolarkServerUrl);
            } else {
                throw new NullPointerException("Neither SciGraph not Biolark URL was specified");
            }
            Objects.requireNonNull(this.ontology, "Ontology must not be null");
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            return new HpoTextMining(this.ontology, usedMiner, this.executorService, this.terms);
        }
    }
}

