/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.graph.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.exc.GraphNotSimpleException;
import org.monarchinitiative.phenol.graph.exc.VerticesAndEdgesIncompatibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilityChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatibilityChecker.class);

    private CompatibilityChecker() {
    }

    public static <V extends Comparable<V>> void check(Collection<V> vertices, Collection<IdLabeledEdge> edges) {
        LOGGER.debug("Checking vertices ({}) and edges ({}) for compatibility...", (Object)vertices.size(), (Object)edges.size());
        HashSet<V> vertexSet = new HashSet<V>(vertices);
        for (IdLabeledEdge edge : edges) {
            if (!vertexSet.contains(edge.getSource())) {
                throw new VerticesAndEdgesIncompatibleException("Unknown source edge in edge " + (Object)((Object)edge));
            }
            if (!vertexSet.contains(edge.getTarget())) {
                throw new VerticesAndEdgesIncompatibleException("Unknown dest edge in edge " + (Object)((Object)edge));
            }
            if (edge.getSource() != edge.getTarget()) continue;
            throw new VerticesAndEdgesIncompatibleException("Self-loop edge " + (Object)((Object)edge));
        }
        LOGGER.debug("Vertices and edges are compatible!");
        HashMap seen = new HashMap();
        for (IdLabeledEdge edge : edges) {
            if (!seen.containsKey(edge.getSource())) {
                seen.put((Comparable)edge.getSource(), new HashSet());
            } else if (((Set)seen.get(edge.getSource())).contains(edge.getTarget())) {
                throw new GraphNotSimpleException("Seen edge twice: " + (Object)((Object)edge));
            }
            ((Set)seen.get(edge.getSource())).add((Comparable)edge.getTarget());
        }
        LOGGER.debug("Graph is simple!");
    }
}

