/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import java.io.Serializable;
import java.util.Objects;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;

public final class TermId
implements Comparable<TermId>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final int separatorPos;
    private final String value;

    public static TermId of(String termId) {
        TermId.requireNonNullOrEmpty(termId, "termId cannot be null or empty");
        int pos = TermId.findPrefixSeparatorPosition(':', termId);
        return new TermId(pos, termId);
    }

    public static TermId of(String termPrefix, String id) {
        TermId.requireNonNullOrEmpty(termPrefix, "termPrefix cannot be null or empty");
        TermId.requireNonNullOrEmpty(id, "term id cannot be null or empty");
        int pos = termPrefix.length();
        String termId = String.join((CharSequence)":", termPrefix, id);
        return new TermId(pos, termId);
    }

    private static void requireNonNullOrEmpty(String input, String message) {
        if (input == null || input.isEmpty()) {
            throw new PhenolRuntimeException(message);
        }
    }

    private static int findPrefixSeparatorPosition(char separator, String termIdString) {
        int pos = termIdString.indexOf(separator);
        if (pos == -1) {
            throw new PhenolRuntimeException("TermId construction error: '" + termIdString + "' does not have a prefix!");
        }
        return pos;
    }

    private TermId(int separatorPos, String termId) {
        this.separatorPos = separatorPos;
        this.value = termId;
    }

    public String getPrefix() {
        return this.value.substring(0, this.separatorPos);
    }

    public String getId() {
        return this.value.substring(this.separatorPos + 1);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(TermId that) {
        return this.value.compareTo(that.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermId termId1 = (TermId)o;
        return Objects.equals(this.value, termId1.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }
}

