/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.scoredist;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.ontology.scoredist.CannotMergeScoreDistributions;
import org.monarchinitiative.phenol.ontology.scoredist.ObjectScoreDistribution;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreDistribution;

public final class ScoreDistributions {
    public static ScoreDistribution merge(Collection<ScoreDistribution> distributions) {
        if (distributions.isEmpty()) {
            throw new CannotMergeScoreDistributions("Cannot merge zero ScoreDistributions objects.");
        }
        if (distributions.stream().map(ScoreDistribution::getNumTerms).collect(Collectors.toSet()).size() != 1) {
            throw new CannotMergeScoreDistributions("Different numbers of terms used for precomputation");
        }
        HashMap<Integer, ObjectScoreDistribution> mapping = new HashMap<Integer, ObjectScoreDistribution>();
        for (ScoreDistribution d : distributions) {
            for (Integer objectId : d.getObjectIds()) {
                ObjectScoreDistribution dist = d.getObjectScoreDistribution(objectId);
                if (mapping.containsKey(objectId)) {
                    throw new CannotMergeScoreDistributions("Duplicate object ID " + objectId + " detected");
                }
                mapping.put(objectId, dist);
            }
        }
        return new ScoreDistribution(distributions.stream().findAny().get().getNumTerms(), mapping);
    }

    public static ScoreDistribution merge(ScoreDistribution ... distributions) {
        return ScoreDistributions.merge(Arrays.asList(distributions));
    }
}

