/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.Similarity;

public final class JaccardSimilarity
implements Similarity {
    private final Ontology ontology;
    private final boolean normalized;

    public JaccardSimilarity(Ontology ontology) {
        this(ontology, true);
    }

    public JaccardSimilarity(Ontology ontology, boolean normalized) {
        this.ontology = ontology;
        this.normalized = normalized;
    }

    @Override
    public String getName() {
        return "Jaccard similarity";
    }

    @Override
    public String getParameters() {
        return "{normalized: " + this.normalized + "}";
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public double computeScore(Collection<TermId> query, Collection<TermId> target) {
        Set<TermId> termIdsQuery = this.ontology.getAllAncestorTermIds(query, false);
        Set<TermId> termIdsTarget = this.ontology.getAllAncestorTermIds(target, false);
        double intersectionSize = Sets.intersection(termIdsQuery, termIdsTarget).size();
        if (this.normalized) {
            return intersectionSize / (double)Sets.union(termIdsQuery, termIdsTarget).size();
        }
        return intersectionSize;
    }
}

